/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.progress.IProgressConstants;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.AopCoreImages;
import org.springframework.ide.eclipse.aop.core.internal.model.AnnotationIntroductionDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReference;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceModel;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanIntroductionDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.JavaAdvisorDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AspectDefinitionBuilderHelper;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AspectDefinitionMatcher;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAopProject;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelMarkerUtils;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class AopReferenceModelBuilderJob
extends Job {
    private static final boolean SHOW_PROGRESS = System.getProperty("org.springframework.ide.eclipse.aop.core.internal.model.builder.show.progress", "false").equalsIgnoreCase("true");
    private static final String DEBUG_OPTION = "org.springframework.ide.eclipse.aop.core/builder/debug";
    private static boolean DEBUG_BUILDER = SpringCore.isDebug((String)"org.springframework.ide.eclipse.aop.core/builder/debug");
    public static final Object CONTENT_FAMILY = new Object();
    private static final String PROCESSING_TOOK_MSG = "Processing took";
    private final Set<IResource> affectedResources;
    private final IProject project;
    private Map<IFile, List<IAspectDefinition>> aspectDefinitionCache = null;
    private IProjectClassLoaderSupport classLoaderSupport;
    private MarkerModifyingJob markerJob = null;
    private AspectDefinitionMatcher aspectDefinitionMatcher = null;
    private AspectDefinitionBuilderHelper aspectDefinitionBuilder;

    public AopReferenceModelBuilderJob(IProject project, Set<IResource> affectedResources, Set<IResource> originalResources) {
        super(Activator.getFormattedMessage("AopReferenceModelProjectBuilder.buildingAopReferenceModel", new Object[0]));
        this.affectedResources = affectedResources;
        this.project = project;
        this.setPriority(40);
        this.setRule(new BlockingOnSelfSchedulingRule());
        this.setSystem(!SHOW_PROGRESS);
        this.setProperty(IProgressConstants.ICON_PROPERTY, AopCoreImages.DESC_OBJS_ASPECT);
    }

    public boolean belongsTo(Object family) {
        return CONTENT_FAMILY == family;
    }

    public boolean isCoveredBy(AopReferenceModelBuilderJob other) {
        if (other.affectedResources != null && this.affectedResources != null) {
            for (IResource resource : this.affectedResources) {
                if (other.affectedResources.contains(resource)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Job[] buildJobs = Job.getJobManager().find(CONTENT_FAMILY);
            int i = 0;
            while (i < buildJobs.length) {
                AopReferenceModelBuilderJob job;
                Job curr = buildJobs[i];
                if (curr != this && curr instanceof AopReferenceModelBuilderJob && (job = (AopReferenceModelBuilderJob)curr).isCoveredBy(this)) {
                    curr.cancel();
                }
                ++i;
            }
        }
        if (!monitor.isCanceled()) {
            long start = System.currentTimeMillis();
            this.buildAopModel(monitor);
            if (DEBUG_BUILDER) {
                System.out.println(String.format("> aop model building took %sms for %s resources", System.currentTimeMillis() - start, this.affectedResources.size()));
            }
        } else {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void buildAopReferencesForBean(final IBean bean, IModelElement context, final IAspectDefinition info, final IResource file, final IAopProject aopProject, IProgressMonitor monitor) {
        try {
            AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.processingBeanDefinition", bean, bean.getElementResource().getFullPath()));
            if (bean.isAbstract()) {
                return;
            }
            final String className = BeansModelUtils.getBeanClass((IBean)bean, (IModelElement)context);
            if (className != null && info.getAspectName() != null && info.getAspectName().equals(bean.getElementName()) && info.getResource() != null && info.getResource().equals((Object)bean.getElementResource())) {
                AopLog.log(4, Activator.getFormattedMessage("AopReferenceModelBuilder.skippingBeanDefinition", bean));
                return;
            }
            final IType jdtTargetType = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
            final IType jdtAspectType = JdtUtils.getJavaType((IProject)aopProject.getProject().getProject(), (String)info.getAspectClassName());
            if (jdtTargetType == null || bean.isFactory()) {
                AopLog.log(4, Activator.getFormattedMessage("AopReferenceModelBuilder.skippingFactoryBeanDefinition", bean));
                return;
            }
            this.classLoaderSupport.executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                public void doWithActiveProjectClassLoader() throws Throwable {
                    block11: {
                        Class targetClass;
                        block10: {
                            targetClass = null;
                            if (AopReferenceModelBuilderJob.this.project != null && AopReferenceModelBuilderJob.this.project.equals((Object)file.getProject())) {
                                targetClass = ClassUtils.loadClass((String)className);
                            } else {
                                ClassLoader loader = JdtUtils.getClassLoader((IProject)file.getProject(), null);
                                targetClass = ClassUtils.loadClass((String)className, (ClassLoader)loader);
                            }
                            if (!(info instanceof BeanIntroductionDefinition)) break block10;
                            BeanIntroductionDefinition intro = (BeanIntroductionDefinition)info;
                            if (!intro.getTypeMatcher().matches(targetClass)) break block11;
                            IType jdtAspectMember = null;
                            if (intro instanceof AnnotationIntroductionDefinition) {
                                String fieldName = ((AnnotationIntroductionDefinition)intro).getDefiningField();
                                jdtAspectMember = jdtAspectType.getField(fieldName);
                            } else {
                                jdtAspectMember = jdtAspectType;
                            }
                            if (jdtAspectMember == null) break block11;
                            AopReference ref = new AopReference(info.getType(), (IMember)jdtAspectMember, JdtUtils.getLineNumber((IJavaElement)jdtAspectMember), (IMember)jdtTargetType, JdtUtils.getLineNumber((IJavaElement)jdtTargetType), info, file, bean);
                            aopProject.addAopReference(ref);
                            break block11;
                        }
                        if (info instanceof BeanAspectDefinition) {
                            IMethod jdtAspectMethod = null;
                            if (info instanceof JavaAdvisorDefinition) {
                                jdtAspectMethod = JdtUtils.getMethod((IType)jdtAspectType, (String)info.getAdviceMethodName(), (String[])info.getAdviceMethodParameterTypes());
                            } else {
                                if (info.getAdviceMethod() == null) {
                                    return;
                                }
                                jdtAspectMethod = JdtUtils.getMethod((IType)jdtAspectType, (String)info.getAdviceMethodName(), (Class[])info.getAdviceMethod().getParameterTypes());
                            }
                            if (jdtAspectMethod != null) {
                                Set<IMethod> matchingMethods = AopReferenceModelBuilderJob.this.aspectDefinitionMatcher.matches(targetClass, bean, info, aopProject.getProject().getProject());
                                for (IMethod method : matchingMethods) {
                                    AopReference ref = new AopReference(info.getType(), (IMember)jdtAspectMethod, JdtUtils.getLineNumber((IJavaElement)jdtAspectMethod), (IMember)method, JdtUtils.getLineNumber((IJavaElement)method), info, file, bean);
                                    aopProject.addAopReference(ref);
                                }
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            this.markerJob.addThrowableHolder(new ThrowableHolder(t, file, bean, info));
        }
    }

    private void buildAopReferencesForBeans(IModelElement config, IAspectDefinition info, IProgressMonitor monitor, IResource file, IAopProject aopProject, Set<IBean> beans) {
        monitor.subTask(Activator.getFormattedMessage("AopReferenceModelBuilder.buildingAopReferences", new Object[0]));
        for (IBean bean : beans) {
            monitor.subTask(Activator.getFormattedMessage("AopReferenceModelBuilder.buildingAopReferencesForBean", bean.getElementName(), bean.getElementResource().getFullPath()));
            this.buildAopReferencesForBean(bean, config, info, file, aopProject, monitor);
            this.buildAopReferencesForBeans(config, info, monitor, file, aopProject, BeansModelUtils.getInnerBeans((IModelElement)bean));
        }
    }

    private void buildAopReferencesForBeansConfig(IBeansConfig config, IAspectDefinition info, IProgressMonitor monitor) {
        IResource file = config.getElementResource();
        IJavaProject javaProject = JdtUtils.getJavaProject((IProject)file.getProject());
        if (javaProject != null) {
            IAopProject aopProject = ((AopReferenceModel)Activator.getModel()).getProjectWithInitialization(javaProject);
            LinkedHashSet<IBean> beans = new LinkedHashSet<IBean>();
            beans.addAll(config.getBeans());
            for (IBeansComponent component : config.getComponents()) {
                this.addBeansFromComponent(component, beans);
            }
            this.buildAopReferencesForBeans((IModelElement)config, info, monitor, file, aopProject, beans);
        }
    }

    private void addBeansFromComponent(IBeansComponent bc, Set<IBean> beans) {
        Set nestedBeans = bc.getBeans();
        for (IBean nestedBean : nestedBeans) {
            if (nestedBean.isInfrastructure()) continue;
            beans.add(nestedBean);
        }
        for (IBeansComponent component : bc.getComponents()) {
            this.addBeansFromComponent(component, beans);
        }
    }

    private IAopProject buildAopReferencesForFile(IFile currentFile, IProgressMonitor monitor) {
        IAopProject aopProject = null;
        IBeansProject project = BeansCorePlugin.getModel().getProject(currentFile.getProject());
        if (project != null) {
            IBeansConfig config = project.getConfig(currentFile, true);
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project.getProject());
            if (javaProject != null && config != null) {
                aopProject = ((AopReferenceModel)Activator.getModel()).getProjectWithInitialization(javaProject);
                aopProject.clearReferencesForResource((IResource)currentFile);
                ArrayList<IAspectDefinition> aspectInfos = new ArrayList<IAspectDefinition>();
                aspectInfos.addAll(this.buildAspectDefinitions(currentFile));
                this.addAspectInfosFromImport(config, aspectInfos);
                for (IAspectDefinition info : aspectInfos) {
                    aopProject.clearReferencesForResource(info.getResource());
                }
                for (IAspectDefinition info : aspectInfos) {
                    this.buildAopReferencesForBeansConfig(config, info, monitor);
                    this.buildAopReferencesFromBeansConfigSets(project, config, info, monitor);
                }
            }
        }
        return aopProject;
    }

    private void addAspectInfosFromImport(IBeansConfig config, List<IAspectDefinition> aspectInfos) {
        for (IBeansImport beansImport : config.getImports()) {
            for (IImportedBeansConfig importedConfig : beansImport.getImportedBeansConfigs()) {
                if (!(importedConfig.getElementResource() instanceof IFile)) continue;
                aspectInfos.addAll(this.buildAspectDefinitions((IFile)importedConfig.getElementResource()));
                this.addAspectInfosFromImport((IBeansConfig)importedConfig, aspectInfos);
            }
        }
    }

    private void buildAopReferencesFromBeansConfigSets(IBeansProject project, IBeansConfig config, IAspectDefinition info, IProgressMonitor monitor) {
        LinkedHashSet<IBeansConfig> foundConfigs = new LinkedHashSet<IBeansConfig>();
        for (IBeansConfigSet configSet : project.getConfigSets()) {
            if (!configSet.getConfigs().contains(config)) continue;
            Set configs = configSet.getConfigs();
            for (IBeansConfig configSetConfig : configs) {
                if (config.equals(configSetConfig)) continue;
                foundConfigs.add(configSetConfig);
            }
        }
        for (IBeansConfig bc : foundConfigs) {
            this.buildAopReferencesForBeansConfig(bc, info, monitor);
        }
    }

    private List<IAspectDefinition> buildAspectDefinitions(IFile file) {
        if (this.aspectDefinitionCache.containsKey(file)) {
            return this.aspectDefinitionCache.get(file);
        }
        List<IAspectDefinition> definitions = this.aspectDefinitionBuilder.buildAspectDefinitions(file, this.classLoaderSupport);
        this.aspectDefinitionCache.put(file, definitions);
        return definitions;
    }

    protected void buildAopModel(IProgressMonitor monitor) {
        AopLog.logStart(PROCESSING_TOOK_MSG);
        AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.startBuildReferenceModel", this.affectedResources.size()));
        this.markerJob = new MarkerModifyingJob();
        this.aspectDefinitionMatcher = new AspectDefinitionMatcher();
        this.aspectDefinitionCache = new HashMap<IFile, List<IAspectDefinition>>();
        this.aspectDefinitionBuilder = new AspectDefinitionBuilderHelper();
        this.classLoaderSupport = this.createWeavingClassLoaderSupport();
        monitor.beginTask(Activator.getFormattedMessage("AopReferenceModelBuilder.startBuildingAopReferenceModel", new Object[0]), this.affectedResources.size());
        HashMap<IFile, IAopProject> processedProjects = new HashMap<IFile, IAopProject>();
        try {
            for (IResource iResource : this.affectedResources) {
                if (!(iResource instanceof IFile)) continue;
                IFile currentFile = (IFile)iResource;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.buildingAopReferenceModel", currentFile.getFullPath().toString()));
                monitor.subTask(Activator.getFormattedMessage("AopReferenceModelBuilder.buildingAopReferenceModel", currentFile.getFullPath().toString()));
                this.markerJob.addResource((IResource)currentFile);
                IAopProject aopProject = this.buildAopReferencesForFile(currentFile, monitor);
                AopLog.log(4, Activator.getFormattedMessage("AopReferenceModelBuilder.constructedAopReferenceModel", new Object[0]));
                if (aopProject != null) {
                    processedProjects.put(currentFile, aopProject);
                }
                monitor.worked(1);
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.doneBuildingReferenceModel", currentFile.getFullPath().toString()));
            }
            for (Map.Entry entry : processedProjects.entrySet()) {
                Set<IAopReference> references = ((IAopProject)entry.getValue()).getAllReferences();
                this.markerJob.addAopReference((IResource)entry.getKey(), references);
            }
            AopLog.logEnd(1, PROCESSING_TOOK_MSG);
        }
        finally {
            this.aspectDefinitionMatcher.close();
            this.aspectDefinitionBuilder.close();
            this.markerJob.schedule();
        }
    }

    protected IProjectClassLoaderSupport createWeavingClassLoaderSupport() {
        return JdtUtils.getProjectClassLoaderSupport((IProject)this.project, null);
    }

    private class BlockingOnSelfSchedulingRule
    implements ISchedulingRule {
        private BlockingOnSelfSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof BlockingOnSelfSchedulingRule;
        }
    }

    private class MarkerModifyingJob
    extends Job {
        private Map<IResource, List<IAopReference>> references;
        private Set<IResource> resources;
        private Set<ThrowableHolder> throwables;

        public MarkerModifyingJob() {
            super("Creating AOP reference model markers");
            this.references = new HashMap<IResource, List<IAopReference>>();
            this.resources = new HashSet<IResource>();
            this.throwables = new HashSet<ThrowableHolder>();
            this.setPriority(10);
            this.setSystem(true);
            this.setProperty(IProgressConstants.ICON_PROPERTY, AopCoreImages.DESC_OBJS_ASPECT);
            this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        }

        public void addAopReference(IResource resource, Set<IAopReference> references) {
            this.references.put(resource, new ArrayList<IAopReference>(references));
        }

        public void addResource(IResource resource) {
            this.resources.add(resource);
        }

        public void addThrowableHolder(ThrowableHolder throwableHolder) {
            this.throwables.add(throwableHolder);
        }

        private void handleException(Throwable t, IAspectDefinition info, IBean bean, IResource file) {
            if (t instanceof NoClassDefFoundError || t instanceof ClassNotFoundException) {
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.classDependencyError", t.getMessage(), info, bean));
                AopReferenceModelMarkerUtils.createProblemMarker(file, Activator.getFormattedMessage("AopReferenceModelBuilder.buildPathIncomplete", t.getMessage()), 2, bean.getElementStartLine(), "org.springframework.ide.eclipse.aop.core.problemmarker", file);
            } else if (t instanceof IllegalArgumentException) {
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.pointcutIsMalformedOnBean", info, bean));
                AopReferenceModelMarkerUtils.createProblemMarker(info.getResource(), Activator.getFormattedMessage("AopReferenceModelBuilder.pointcutIsMalformed", t.getMessage()), 2, info.getAspectStartLineNumber(), "org.springframework.ide.eclipse.aop.core.problemmarker", info.getResource());
            } else if (t instanceof InvocationTargetException || t instanceof RuntimeException) {
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.exceptionFromReflectionOnBean", info, bean));
                if (t.getCause() != null) {
                    this.handleException(t.getCause(), info, bean, file);
                } else if (!t.getMessage().contains("sun.reflect.annotation.TypeNotPresentException")) {
                    Activator.log(t);
                    AopReferenceModelMarkerUtils.createProblemMarker(file, Activator.getFormattedMessage("AopReferenceModelBuilder.exceptionFromReflection", t.getMessage()), 1, info.getAspectStartLineNumber(), "org.springframework.ide.eclipse.aop.core.problemmarker", file);
                }
            } else {
                AopLog.log(1, Activator.getFormattedMessage("AopReferenceModelBuilder.exception", t.getMessage(), info, bean));
                Activator.log(t);
                AopReferenceModelMarkerUtils.createProblemMarker(file, Activator.getFormattedMessage("AopReferenceModelBuilder.exception", t.getMessage()), 1, info.getAspectStartLineNumber(), "org.springframework.ide.eclipse.aop.core.problemmarker", file);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                for (IResource currentFile : this.resources) {
                    monitor.beginTask("Creating AOP reference model markers for file [" + currentFile.getFullPath().toString() + "]", -1);
                    AopReferenceModelMarkerUtils.deleteProblemMarkers(currentFile);
                    AopLog.log(4, Activator.getFormattedMessage("AopReferenceModelBuilder.deletedProblemMarkers", currentFile.getFullPath().toString()));
                    if (!this.references.containsKey(currentFile) || this.references.get(currentFile) == null) continue;
                    for (IAopReference reference : this.references.get(currentFile)) {
                        if (!reference.getDefinition().getResource().equals((Object)currentFile) && !reference.getResource().equals((Object)currentFile)) continue;
                        AopReferenceModelMarkerUtils.createMarker(reference, currentFile);
                    }
                    AopLog.log(4, Activator.getFormattedMessage("AopReferenceModelBuilder.createdProblemMarkers", currentFile.getFullPath().toString()));
                }
                for (ThrowableHolder holder : this.throwables) {
                    this.handleException(holder.getThrowable(), holder.getAspectDefinition(), holder.getBean(), holder.getResource());
                }
                Activator.getModel().fireModelChanged();
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                Activator.log(e);
                return Status.CANCEL_STATUS;
            }
        }
    }

    private class ThrowableHolder {
        private IAspectDefinition aspectDefinition;
        private IBean bean;
        private IResource resource;
        private Throwable throwable;

        public ThrowableHolder(Throwable throwable, IResource resource, IBean bean, IAspectDefinition aspectDefinition) {
            this.throwable = throwable;
            this.resource = resource;
            this.bean = bean;
            this.aspectDefinition = aspectDefinition;
        }

        public IAspectDefinition getAspectDefinition() {
            return this.aspectDefinition;
        }

        public IBean getBean() {
            return this.bean;
        }

        public IResource getResource() {
            return this.resource;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

