/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import org.springframework.ide.eclipse.beans.core.model.validation.AbstractXmlValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.w3c.dom.Node;

public class ImportElementsAtTopRule
extends AbstractXmlValidationRule {
    public static final String INFO_MESSAGE = "Imports should appear before bean definitions.";
    public static final String ERROR_ID = "importElementsAtTop";

    protected boolean supports(Node node) {
        return node.getNodeName().equals("import");
    }

    protected void validate(Node node, IXmlValidationContext context) {
        Node currNode = node.getPreviousSibling();
        while (currNode != null) {
            if (currNode.getNodeName().equalsIgnoreCase("bean")) {
                context.info(node, ERROR_ID, INFO_MESSAGE, new ValidationProblemAttribute[0]);
                return;
            }
            currNode = currNode.getPreviousSibling();
        }
    }
}

