/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.monitor.core.operations;

import com.atlassian.connector.eclipse.internal.monitor.core.Messages;
import com.atlassian.connector.eclipse.monitor.core.InteractionEvent;
import com.atlassian.connector.eclipse.monitor.core.InteractionEventLogger;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import java.io.File;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;

public final class UploadMonitoringStatusJob
extends Job {
    private final boolean enabled;

    public UploadMonitoringStatusJob(boolean enabled) {
        super("Reporting Usage Data Monitoring Status");
        this.setPriority(20);
        this.setUser(false);
        this.setSystem(true);
        this.enabled = enabled;
    }

    protected IStatus run(IProgressMonitor monitor) {
        File monitoringDisabledLog;
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            monitoringDisabledLog = this.createMonitoringDisabledLog((IProgressMonitor)submonitor.newChild(1));
        }
        catch (IOException iOException) {
            return Status.OK_STATUS;
        }
        try {
            this.upload("https://update.atlassian.com/atlassian-eclipse-plugin/usage-collector/upload-2", monitoringDisabledLog, monitor);
        }
        finally {
            monitoringDisabledLog.delete();
        }
        return Status.OK_STATUS;
    }

    private File createMonitoringDisabledLog(IProgressMonitor monitor) throws IOException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor);
        File temp = File.createTempFile("temp.", ".xml");
        try {
            InteractionEventLogger iel = new InteractionEventLogger(temp);
            iel.startMonitoring();
            iel.interactionObserved(InteractionEvent.makePreference("com.atlassian.connector.eclipse.monitor.core", "monitoring.enabled", Boolean.toString(this.enabled)));
            iel.stopMonitoring();
            File zipFile = File.createTempFile(String.valueOf(MonitorCorePlugin.getDefault().getUserId()) + ".", ".zip");
            ZipFileUtil.createZipFile((File)zipFile, Arrays.asList(temp), (IProgressMonitor)submonitor.newChild(1));
            File file = zipFile;
            return file;
        }
        finally {
            temp.delete();
        }
    }

    private boolean upload(String uploadUrl, File log, IProgressMonitor monitor) {
        int status = 0;
        try {
            PostMethod filePost = new PostMethod(uploadUrl);
            try {
                Part[] parts = new Part[]{new FilePart("temp.txt", log, "application/zip", "ISO-8859-1")};
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                HttpClient client = new HttpClient();
                status = client.executeMethod((HttpMethod)filePost);
            }
            finally {
                filePost.releaseConnection();
            }
        }
        catch (Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_no_network, (Throwable)e));
            } else {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", Messages.UsageDataUploadJob_unknown_exception, (Throwable)e));
            }
            return false;
        }
        return status == 200;
    }
}

