/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.core.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryClientManager<T, C extends Serializable>
implements IRepositoryListener {
    private final Map<String, T> clientByUrl = new HashMap<String, T>();
    private final Map<String, C> clientDataByUrl = new HashMap<String, C>();
    private final File cacheFile;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory;

    public RepositoryClientManager(File cacheFile) {
        Assert.isNotNull((Object)cacheFile);
        this.cacheFile = cacheFile;
        this.readCache();
    }

    public synchronized T getClient(TaskRepository taskRepository) {
        Assert.isNotNull((Object)taskRepository);
        T client = this.clientByUrl.get(taskRepository.getRepositoryUrl());
        if (client == null) {
            Serializable data = (Serializable)this.getClientDataByUrl().get(taskRepository.getRepositoryUrl());
            if (data == null) {
                data = this.createRepositoryConfiguration();
                this.getClientDataByUrl().put(taskRepository.getRepositoryUrl(), data);
            }
            client = this.createClient(taskRepository, data);
            this.clientByUrl.put(taskRepository.getRepositoryUrl(), client);
        }
        return client;
    }

    protected abstract C createRepositoryConfiguration();

    protected abstract T createClient(TaskRepository var1, C var2);

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
    }

    protected void removeClient(TaskRepository repository, Map<String, T> clientByUrl, Map<String, C> clientDataByUrl) {
        clientByUrl.remove(repository.getRepositoryUrl());
    }

    public void removeClient(TaskRepository repository) {
        this.clientByUrl.remove(repository.getRepositoryUrl());
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository, this.clientByUrl, this.getClientDataByUrl());
        this.getClientDataByUrl().remove(repository.getRepositoryUrl());
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository, this.clientByUrl, this.getClientDataByUrl());
    }

    protected ObjectInput createObjectInput(File cacheFile) throws FileNotFoundException, IOException {
        return new ObjectInputStream(new FileInputStream(cacheFile));
    }

    protected ObjectOutput createObjectOutput(File cacheFile) throws IOException {
        return new ObjectOutputStream(new FileOutputStream(cacheFile));
    }

    protected void readCache() {
        block17: {
            if (this.getCacheFile() == null || !this.getCacheFile().exists()) {
                return;
            }
            ObjectInput in = null;
            try {
                try {
                    in = this.createObjectInput(this.getCacheFile());
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        Serializable data = (Serializable)in.readObject();
                        if (url != null && data != null) {
                            this.getClientDataByUrl().put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.core", "The repository configuration cache could not be read", e));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeCache() {
        block16: {
            this.updateClientDataMap(this.clientByUrl, this.getClientDataByUrl());
            if (this.getCacheFile() == null) {
                return;
            }
            ObjectOutput out = null;
            try {
                try {
                    out = this.createObjectOutput(this.getCacheFile());
                    out.writeInt(this.getClientDataByUrl().size());
                    for (String url : this.getClientDataByUrl().keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.getClientDataByUrl().get(url));
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.core", "The repository configuration cache could not be written", (Throwable)e));
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void updateClientDataMap(Map<String, T> var1, Map<String, C> var2);

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }

    protected File getCacheFile() {
        return this.cacheFile;
    }

    protected Map<String, C> getClientDataByUrl() {
        return this.clientDataByUrl;
    }
}

