/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.wizards;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.springframework.ide.eclipse.metadata.MetadataPlugin;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingMethodToClassMap;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingView;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewLabelProvider;
import org.springframework.ide.eclipse.metadata.wizards.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class OpenRequestMappingUrlWizardPage
extends WizardPage {
    private static String PREFIX_VARIABLE_PREFS = "com.springsource.sts.metadata.url.wizard.variables";
    private static String KEY_ROOT = "root";
    private static String KEY_URL_DATA = "urlData";
    private static String KEY_NAME = "name";
    private static String KEY_VALUE = "value";
    private IPreferenceStore prefStore;
    private String prefStoreKey;
    private RequestMappingMethodToClassMap input;
    private RequestMappingViewLabelProvider labelProvider;
    private IProject project;
    private List<Combo> comboList;
    private Map<String, List<String>> cacheMap;
    private Combo urlText;

    protected OpenRequestMappingUrlWizardPage(RequestMappingMethodToClassMap input, RequestMappingViewLabelProvider labelProvider, IProject project) {
        super(Messages.OpenRequestMappingUrlWizardPage_PAGE_TITLE);
        this.setTitle(Messages.OpenRequestMappingUrlWizardPage_HEADER_TITLE);
        this.setDescription(Messages.OpenRequestMappingUrlWizardPage_DESCRIPTION);
        this.input = input;
        this.labelProvider = labelProvider;
        this.project = project;
        this.prefStore = MetadataPlugin.getDefault().getPreferenceStore();
        this.prefStoreKey = PREFIX_VARIABLE_PREFS.concat(input.getMethodMetadata().getHandleIdentifier());
        this.comboList = new ArrayList<Combo>();
        this.cacheMap = new HashMap<String, List<String>>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        HashSet<String> urlInput = new HashSet<String>();
        IModule[] modules = ServerUtil.getModules((IProject)this.project);
        if (modules != null) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IServer[] servers;
                IModule module = iModuleArray[n2];
                IServer[] iServerArray = servers = ServerUtil.getServersByModule((IModule)module, (IProgressMonitor)new NullProgressMonitor());
                int n3 = servers.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL url;
                    IServer server = iServerArray[n4];
                    IURLProvider provider = (IURLProvider)server.loadAdapter(IURLProvider.class, (IProgressMonitor)new NullProgressMonitor());
                    if (provider != null && (url = provider.getModuleRootURL(module)) != null) {
                        urlInput.add(url.toString());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        Label urlLabel = new Label(container, 0);
        urlLabel.setText(Messages.OpenRequestMappingUrlWizardPage_LABEL_URL_PREFIX);
        this.urlText = new Combo(container, 4);
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.addModifyListener((ModifyListener)new TextModifyListener());
        if (urlInput.size() > 0) {
            this.urlText.setItems(urlInput.toArray(new String[urlInput.size()]));
            this.urlText.select(0);
        }
        this.loadPreferenceCache();
        this.createVariableControls(container);
        this.setControl((Control)container);
        this.setPageComplete(this.validatePage());
    }

    private void createVariableControls(Composite parent) {
        String url = this.labelProvider.getColumnText(this.input, RequestMappingView.COLUMN_URL);
        Pattern pattern = Pattern.compile("\\{\\w*\\}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String textLabel = matcher.group();
            Label label = new Label(parent, 0);
            label.setText(String.valueOf(textLabel) + ": ");
            Combo combo = new Combo(parent, 4);
            combo.setData(KEY_URL_DATA, (Object)textLabel);
            combo.setLayoutData((Object)new GridData(768));
            this.comboList.add(combo);
            if (this.cacheMap.containsKey(textLabel)) {
                List<String> strings = this.cacheMap.get(textLabel);
                combo.setItems(strings.toArray(new String[strings.size()]));
                combo.setText(combo.getItem(0));
            }
            combo.addModifyListener((ModifyListener)new TextModifyListener());
        }
    }

    private void loadPreferenceCache() {
        String cache = this.prefStore.getString(this.prefStoreKey);
        if (cache != null && cache.length() > 0) {
            try {
                IMemento[] children;
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(cache));
                IMemento[] iMementoArray = children = memento.getChildren(KEY_URL_DATA);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    String name = child.getString(KEY_NAME);
                    String value = child.getString(KEY_VALUE);
                    if (name != null && value != null) {
                        List<String> subList = this.cacheMap.get(name);
                        if (subList == null) {
                            subList = new LinkedList<String>();
                        }
                        subList.add(value);
                        this.cacheMap.put(name, subList);
                    }
                    ++n2;
                }
            }
            catch (WorkbenchException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", Messages.OpenRequestMappingUrlWizardPage_ERROR_LOADING_CACHE, (Throwable)e));
            }
        }
    }

    private void savePreferenceCache() {
        String mementoString = null;
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)KEY_ROOT);
        block2: for (Combo combo : this.comboList) {
            String textLabel = (String)combo.getData(KEY_URL_DATA);
            String value = combo.getText();
            List<String> subList = this.cacheMap.get(textLabel);
            if (subList == null) {
                subList = new LinkedList<String>();
            }
            subList.remove(value);
            subList.add(0, value);
            this.cacheMap.put(textLabel, subList);
            int i = 0;
            while (i < subList.size()) {
                if (i >= 10) continue block2;
                IMemento child = rootMemento.createChild(KEY_URL_DATA);
                child.putString(KEY_NAME, textLabel);
                child.putString(KEY_VALUE, subList.get(i));
                ++i;
            }
        }
        try {
            StringWriter writer = new StringWriter();
            rootMemento.save((Writer)writer);
            mementoString = writer.getBuffer().toString();
            this.prefStore.setValue(this.prefStoreKey, mementoString);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", Messages.OpenRequestMappingUrlWizardPage_ERROR_SAVING_CACHE, (Throwable)e));
        }
    }

    private String getConstructedUrl() {
        String url = "";
        if (this.urlText != null && (url = this.urlText.getText()).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        url = url.concat(this.labelProvider.getColumnText(this.input, RequestMappingView.COLUMN_URL));
        for (Combo combo : this.comboList) {
            String textLabel = (String)combo.getData(KEY_URL_DATA);
            url = url.replace(textLabel, combo.getText());
        }
        return url;
    }

    protected void performPageFinish() {
        this.savePreferenceCache();
        TasksUiUtil.openUrl((String)this.getConstructedUrl());
    }

    private boolean validatePage() {
        if (!this.comboList.isEmpty()) {
            for (Combo combo : this.comboList) {
                if (combo.getText() != null && combo.getText().length() > 0) continue;
                return false;
            }
        }
        return this.urlText.getText() != null && this.urlText.getText().length() > 0;
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String errorMessage = null;
            boolean valid = OpenRequestMappingUrlWizardPage.this.validatePage();
            if (!valid) {
                errorMessage = "'" + OpenRequestMappingUrlWizardPage.this.getConstructedUrl() + Messages.OpenRequestMappingUrlWizardPage_WARNING_URL_CONSTRUCTION;
            }
            OpenRequestMappingUrlWizardPage.this.setErrorMessage(errorMessage);
            OpenRequestMappingUrlWizardPage.this.setPageComplete(valid);
        }
    }
}

