/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.locate;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.beans.core.model.locate.AbstractJavaProjectPathMatchingBeansConfigLocator;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamicWebProjectBeansConfigLocator
extends AbstractJavaProjectPathMatchingBeansConfigLocator {
    private static final String CONFIG_SET_NAME = "web-context";
    private static final String CONTEXT_CONFIG_LOCATION_PARAM_NAME = "contextConfigLocation";
    private static final String CONTEXT_CONTEXT_LOADER_LISTENER_SERVLET = "org.springframework.web.context.ContextLoaderListener";
    private static final String CONTEXT_CONTEXT_LOADER_SERVLET_CLASS = "org.springframework.web.context.ContextLoaderServlet";
    private static final String DISPATCHER_SERVLET_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final String MESSAGE_DISPATCHER_SERVLET_CLASS = "org.springframework.ws.transport.http.MessageDispatcherServlet";
    private static final String LISTENER_XPATH_EXPRESSION = "//web-app/listener";
    private static final String CONTEXT_PARAM_XPATH_EXPRESSION = "//web-app/context-param";
    private static final String SERVLET_XPATH_EXPRESSION = "//web-app/servlet";
    private static final String LISTENER_CLASS = "listener-class";
    private static final String INIT_PARAM = "init-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CONTEXT_SUFFIX = "-servlet.xml";
    private Set<String> filePatterns = new ConcurrentSkipListSet<String>();
    private final XPathExpression servletExpression;
    private final XPathExpression listenerExpression;
    private final XPathExpression contextParamExpression;

    public DynamicWebProjectBeansConfigLocator() {
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            this.servletExpression = xpath.compile(SERVLET_XPATH_EXPRESSION);
            this.listenerExpression = xpath.compile(LISTENER_XPATH_EXPRESSION);
            this.contextParamExpression = xpath.compile(CONTEXT_PARAM_XPATH_EXPRESSION);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBeansConfigSetName(Set<IFile> files) {
        return CONFIG_SET_NAME;
    }

    public boolean requiresRefresh(IFile file) {
        IFile webArtifact;
        if (file.getFullPath().toString().endsWith("WEB-INF/web.xml") && (webArtifact = SpringCoreUtils.getDeploymentDescriptor((IProject)file.getProject())) != null) {
            return file.getFullPath().equals((Object)webArtifact.getFullPath());
        }
        return false;
    }

    public boolean supports(IProject project) {
        return SpringCoreUtils.isSpringProject((IResource)project) && SpringCoreUtils.hasProjectFacet((IResource)project, (String)"jst.web");
    }

    private String getChildValue(Element node, String nodeName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (nodeName.equals(child.getNodeName())) {
                return child.getTextContent();
            }
            ++i;
        }
        return null;
    }

    private boolean processContextConfigLocationParameter(NodeList initParams) {
        boolean nonDefaultLocations = false;
        int i = 0;
        while (i < initParams.getLength()) {
            String name = null;
            String value = null;
            Node initParam = initParams.item(i);
            NodeList initParamChildren = initParam.getChildNodes();
            int j = 0;
            while (j < initParamChildren.getLength()) {
                Node initParamChild = initParamChildren.item(j);
                if (PARAM_NAME.equals(initParamChild.getNodeName())) {
                    name = initParamChild.getTextContent();
                } else if (PARAM_VALUE.equals(initParamChild.getNodeName())) {
                    value = initParamChild.getTextContent();
                }
                ++j;
            }
            if (CONTEXT_CONFIG_LOCATION_PARAM_NAME.equals(name) && StringUtils.hasText(value)) {
                String[] configLocations = StringUtils.tokenizeToStringArray(value, (String)",; \t\n");
                nonDefaultLocations = true;
                String[] stringArray = configLocations;
                int n = configLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    String configLocation = stringArray[n2];
                    int ix = configLocation.indexOf(58);
                    if (ix > 0) {
                        configLocation = configLocation.substring(ix + 1);
                    }
                    this.filePatterns.add(configLocation);
                    ++n2;
                }
            }
            ++i;
        }
        if (!nonDefaultLocations) {
            this.filePatterns.add("/WEB-INF/applicationContext.xml");
        }
        return nonDefaultLocations;
    }

    protected boolean canLocateInProject(IProject project) {
        if (!super.canLocateInProject(project)) {
            return false;
        }
        IFile deploymentDescriptor = SpringCoreUtils.getDeploymentDescriptor((IProject)project);
        if (deploymentDescriptor != null) {
            Element element;
            int i;
            NodeList nodes;
            try {
                nodes = (NodeList)this.servletExpression.evaluate(SpringCoreUtils.parseDocument((IFile)deploymentDescriptor), XPathConstants.NODESET);
                i = 0;
                while (i < nodes.getLength()) {
                    element = (Element)nodes.item(i);
                    String servletName = this.getChildValue(element, SERVLET_NAME);
                    String servletClass = this.getChildValue(element, SERVLET_CLASS);
                    if (StringUtils.hasText((String)servletName) && StringUtils.hasText((String)servletClass)) {
                        NodeList initParams;
                        if (DISPATCHER_SERVLET_CLASS.equals(servletClass) || MESSAGE_DISPATCHER_SERVLET_CLASS.equals(servletClass)) {
                            initParams = element.getElementsByTagName(INIT_PARAM);
                            boolean nonDefaultLocations = this.processContextConfigLocationParameter(initParams);
                            if (!nonDefaultLocations) {
                                this.filePatterns.add("/WEB-INF/" + servletName + SERVLET_CONTEXT_SUFFIX);
                            }
                        } else if (CONTEXT_CONTEXT_LOADER_SERVLET_CLASS.equals(servletClass)) {
                            initParams = element.getElementsByTagName(INIT_PARAM);
                            this.processContextConfigLocationParameter(initParams);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SpringCore.log((IStatus)new Status(2, "org.springframework.ide.eclipse.metadata", 1, e.getMessage(), (Throwable)e));
            }
            try {
                nodes = (NodeList)this.listenerExpression.evaluate(SpringCoreUtils.parseDocument((IFile)deploymentDescriptor), XPathConstants.NODESET);
                i = 0;
                while (i < nodes.getLength()) {
                    element = (Element)nodes.item(i);
                    String listenerClass = this.getChildValue(element, LISTENER_CLASS);
                    if (CONTEXT_CONTEXT_LOADER_LISTENER_SERVLET.equals(listenerClass)) {
                        NodeList contextParams = (NodeList)this.contextParamExpression.evaluate(SpringCoreUtils.parseDocument((IFile)deploymentDescriptor), XPathConstants.NODESET);
                        this.processContextConfigLocationParameter(contextParams);
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SpringCore.log((IStatus)new Status(2, "org.springframework.ide.eclipse.metadata", 1, e.getMessage(), (Throwable)e));
            }
        } else {
            return false;
        }
        return true;
    }

    protected Set<String> getAllowedFilePatterns() {
        return this.filePatterns;
    }

    protected Set<IPath> getRootDirectories(IProject project) {
        IPath path;
        LinkedHashSet<IPath> rootDirectories = new LinkedHashSet<IPath>(super.getRootDirectories(project));
        IFile webArtifact = SpringCoreUtils.getDeploymentDescriptor((IProject)project);
        if (webArtifact != null && (path = webArtifact.getFullPath()) != null) {
            rootDirectories.add(path.removeLastSegments(2));
        }
        return rootDirectories;
    }
}

