/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.workingsets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreePath;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.ui.workingsets.IWorkingSetFilter;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowWorkingSetViewerFilter
implements IWorkingSetFilter {
    public boolean isInWorkingSet(IAdaptable[] elements, Object parentElement, Object element) {
        IProject project;
        if (element instanceof ISpringProject) {
            IProject project2 = ((ISpringProject)element).getProject();
            if (this.checkProject(elements, project2)) {
                return true;
            }
        } else if (element instanceof IWebflowProject) {
            IProject project3 = ((IWebflowProject)element).getProject();
            if (this.checkProject(elements, project3)) {
                return true;
            }
        } else if (parentElement instanceof TreePath && this.checkProject(elements, project = this.getProjectFromTreePath((TreePath)parentElement))) {
            IAdaptable[] iAdaptableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IWebflowConfig wc;
                IAdaptable adaptable = iAdaptableArray[n2];
                if (element.equals(adaptable)) {
                    return true;
                }
                if (adaptable instanceof IFile && element.equals(wc = WebflowModelUtils.getWebflowConfig((IFile)((IFile)adaptable)))) {
                    return true;
                }
                if (element instanceof IBeansModelElement && !(element instanceof IBeansConfigSet)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkProject(IAdaptable[] elements, IProject project) {
        if (project == null) {
            return false;
        }
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null && WebflowModelUtils.isWebflowConfig((IResource)resource) && project.equals((Object)resource.getProject())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IProject getProjectFromTreePath(TreePath treePath) {
        int i = 0;
        while (i < treePath.getSegmentCount()) {
            if (treePath.getSegment(i) instanceof IWebflowProject) {
                return ((IWebflowProject)treePath.getSegment(i)).getProject();
            }
            ++i;
        }
        return null;
    }
}

