/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator.filters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class NonSpringArtefactsFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IWebflowModel model = Activator.getModel();
            IWebflowProject project = model.getProject(folder.getProject());
            if (project != null) {
                String path = String.valueOf(folder.getProjectRelativePath().toString()) + '/';
                for (IWebflowConfig config : project.getConfigs()) {
                    if (!config.getResource().getProjectRelativePath().toString().startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            IWebflowModel model = Activator.getModel();
            IWebflowProject project = model.getProject(file.getProject());
            if (project != null) {
                for (IWebflowConfig config : project.getConfigs()) {
                    if (!config.getResource().equals((Object)file)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

