/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorDefinition;
import org.springframework.ide.eclipse.core.SpringCore;

public class BeansConfigLocatorFactory {
    public static final String BEANSCONFIG_LOCATORS_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.beansconfiglocators";
    private static List<BeansConfigLocatorDefinition> configLocatorDefinitions;

    public static synchronized List<BeansConfigLocatorDefinition> getBeansConfigLocatorDefinitions() {
        if (configLocatorDefinitions != null) {
            return configLocatorDefinitions;
        }
        configLocatorDefinitions = new ArrayList<BeansConfigLocatorDefinition>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(BEANSCONFIG_LOCATORS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    try {
                        BeansConfigLocatorDefinition builderDefinition = new BeansConfigLocatorDefinition(config);
                        configLocatorDefinitions.add(builderDefinition);
                    }
                    catch (CoreException e) {
                        SpringCore.log((Throwable)e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        Collections.sort(configLocatorDefinitions, new Comparator<BeansConfigLocatorDefinition>(){

            @Override
            public int compare(BeansConfigLocatorDefinition o1, BeansConfigLocatorDefinition o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        return configLocatorDefinitions;
    }

    public static boolean hasEnabledBeansConfigLocatorDefinitions(IProject project) {
        for (BeansConfigLocatorDefinition builderDefinition : BeansConfigLocatorFactory.getBeansConfigLocatorDefinitions()) {
            if (!builderDefinition.getBeansConfigLocator().supports(project)) continue;
            return true;
        }
        return false;
    }
}

