/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractNonInfrastructureBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class BeanAliasRule
extends AbstractNonInfrastructureBeanValidationRule
implements IValidationRule<IBeanAlias, IBeansValidationContext> {
    @Override
    protected boolean supportsModelElementForNonInfrastructureBean(IModelElement element, IBeansValidationContext context) {
        return element instanceof IBeanAlias;
    }

    public void validate(IBeanAlias alias, IBeansValidationContext context, IProgressMonitor monitor) {
        IBeansConfigSet configSet;
        IBeansConfigSet iBeansConfigSet = configSet = context.getContextElement() instanceof IBeansConfigSet ? (IBeansConfigSet)context.getContextElement() : null;
        if (context.getIncompleteRegistry().containsBeanDefinition(alias.getElementName())) {
            if (configSet == null || BeansModelUtils.getConfig(alias).getBean(alias.getElementName()) != null) {
                context.error((IResourceModelElement)alias, "BEAN_OVERRIDE", "Overrides another bean in the same config file", new ValidationProblemAttribute[0]);
            } else if (!configSet.isAllowBeanDefinitionOverriding()) {
                context.error((IResourceModelElement)alias, "BEAN_OVERRIDE", "Overrides another bean in config set '" + configSet.getElementName() + "'", new ValidationProblemAttribute[0]);
            }
        }
        for (IBeanAlias al : BeansModelUtils.getConfig(alias).getAliases()) {
            if (al == alias || !al.getElementName().equals(alias.getElementName())) continue;
            context.error((IResourceModelElement)alias, "ALIAS_OVERRIDE", "Overrides another alias in the same config file", new ValidationProblemAttribute[0]);
            break;
        }
        if (configSet != null) {
            if (!configSet.isAllowAliasOverriding()) {
                for (IBeansConfig config : configSet.getConfigs()) {
                    if (config == BeansModelUtils.getConfig(alias)) break;
                    if (config.getAlias(alias.getElementName()) == null) continue;
                    context.error((IResourceModelElement)alias, "ALIAS_OVERRIDE", "Overrides another alias in config set '" + configSet.getElementName() + "'", new ValidationProblemAttribute[0]);
                    break;
                }
            }
            if (!configSet.isIncomplete() && !context.getCompleteRegistry().containsBeanDefinition(alias.getBeanName())) {
                context.warning((IResourceModelElement)alias, "UNDEFINED_REFERENCED_BEAN", "Referenced bean '" + alias.getBeanName() + "' not found in config set '" + configSet.getElementName() + "'", new ValidationProblemAttribute[0]);
            }
        }
    }
}

