/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.NamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.TargetNamespaceScanner;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionListener;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ProjectClasspathNamespaceDefinitionResolver
implements INamespaceDefinitionResolver {
    public static final String DEFAULT_HANDLER_MAPPINGS_LOCATION = "META-INF/spring.handlers";
    public static final String DEFAULT_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    public static final String DEFAULT_TOOLING_MAPPINGS_LOCATION = "META-INF/spring.tooling";
    private Map<String, NamespaceDefinition> namespaceDefinitionRegistry = null;
    private final IProject project;
    private EnablementPropertyChangeListener propertyChangeListener;
    private final INamespaceDefinitionResolver resolver;

    public ProjectClasspathNamespaceDefinitionResolver(IProject project) {
        this.project = project;
        this.resolver = BeansCorePlugin.getNamespaceDefinitionResolver();
        this.init();
        this.registerListeners();
    }

    public void dispose() {
        this.unRegisterListeners();
    }

    @Override
    public Set<INamespaceDefinition> getNamespaceDefinitions() {
        return new HashSet<INamespaceDefinition>(this.namespaceDefinitionRegistry.values());
    }

    @Override
    public INamespaceDefinition resolveNamespaceDefinition(String namespaceUri) {
        return this.namespaceDefinitionRegistry.get(namespaceUri);
    }

    private void init() {
        this.namespaceDefinitionRegistry = new ConcurrentHashMap<String, NamespaceDefinition>();
        if (NamespaceUtils.useNamespacesFromClasspath(this.project)) {
            ClassLoader cls = JdtUtils.getClassLoader((IProject)this.project, null);
            HashMap handlerMappings = new HashMap();
            HashMap toolingMappings = new HashMap();
            Properties schemaMappings = new Properties();
            try {
                Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)DEFAULT_HANDLER_MAPPINGS_LOCATION, (ClassLoader)cls);
                CollectionUtils.mergePropertiesIntoMap((Properties)mappings, handlerMappings);
                schemaMappings = PropertiesLoaderUtils.loadAllProperties((String)DEFAULT_SCHEMA_MAPPINGS_LOCATION, (ClassLoader)cls);
                mappings = PropertiesLoaderUtils.loadAllProperties((String)DEFAULT_TOOLING_MAPPINGS_LOCATION, (ClassLoader)cls);
                CollectionUtils.mergePropertiesIntoMap((Properties)mappings, toolingMappings);
            }
            catch (IOException iOException) {}
            for (Object xsd : schemaMappings.keySet()) {
                String namespaceUri;
                String key = xsd.toString();
                String schemaUri = schemaMappings.getProperty(key);
                URL url = cls.getResource(schemaUri);
                if (url == null && schemaUri.startsWith("/")) {
                    schemaUri = schemaUri.substring(1);
                    url = cls.getResource(schemaUri);
                }
                if (url == null || !StringUtils.hasText((String)(namespaceUri = TargetNamespaceScanner.getTargetNamespace(url)))) continue;
                String icon = (String)toolingMappings.get(String.valueOf(namespaceUri) + "@icon");
                String prefix = (String)toolingMappings.get(String.valueOf(namespaceUri) + "@prefix");
                String name = (String)toolingMappings.get(String.valueOf(namespaceUri) + "@name");
                if (this.namespaceDefinitionRegistry.containsKey(namespaceUri)) {
                    this.namespaceDefinitionRegistry.get(namespaceUri).addSchemaLocation(key);
                    this.namespaceDefinitionRegistry.get(namespaceUri).addUri(schemaUri);
                    continue;
                }
                File iconFile = this.extractIcon(namespaceUri, icon, cls);
                ExternalImageNamespaceDefinition namespaceDefinition = new ExternalImageNamespaceDefinition(schemaMappings, iconFile);
                namespaceDefinition.setName(name);
                namespaceDefinition.setPrefix(prefix);
                namespaceDefinition.setIconPath(icon);
                namespaceDefinition.addSchemaLocation(key);
                namespaceDefinition.setNamespaceUri(namespaceUri);
                namespaceDefinition.addUri(schemaUri);
                this.namespaceDefinitionRegistry.put(namespaceUri, namespaceDefinition);
            }
        } else {
            for (INamespaceDefinition namespaceDefinition : this.resolver.getNamespaceDefinitions()) {
                this.namespaceDefinitionRegistry.put(namespaceDefinition.getNamespaceUri(), (NamespaceDefinition)namespaceDefinition);
            }
        }
    }

    private File extractIcon(String namespaceUri, String icon, ClassLoader cls) {
        if (StringUtils.hasLength((String)icon)) {
            try {
                File iconDir = BeansCorePlugin.getDefault().getStateLocation().append("images").toFile();
                if (!iconDir.exists()) {
                    iconDir.mkdirs();
                    iconDir.deleteOnExit();
                }
                int ix = icon.lastIndexOf(46);
                File iconFile = null;
                iconFile = ix > 0 ? new File(iconDir, String.valueOf(Integer.toString(namespaceUri.hashCode())) + icon.substring(ix)) : new File(iconDir, Integer.toString(namespaceUri.hashCode()));
                if (iconFile.exists()) {
                    return iconFile;
                }
                FileCopyUtils.copy((InputStream)cls.getResourceAsStream(icon), (OutputStream)new FileOutputStream(iconFile));
                return iconFile;
            }
            catch (Exception e) {
                BeansCorePlugin.log(String.format("Error extracting icon file '%s' for namespace '%s'", icon, namespaceUri), e);
                return null;
            }
        }
        return null;
    }

    private void registerListeners() {
        this.propertyChangeListener = new EnablementPropertyChangeListener();
        BeansCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this.propertyChangeListener);
        SpringCorePreferences.getProjectPreferences((IProject)this.project, (String)"org.springframework.ide.eclipse.beans.core").getProjectPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.propertyChangeListener);
        BeansCorePlugin.registerNamespaceDefinitionListener(this.propertyChangeListener);
    }

    private void unRegisterListeners() {
        BeansCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this.propertyChangeListener);
        SpringCorePreferences.getProjectPreferences((IProject)this.project, (String)"org.springframework.ide.eclipse.beans.core").getProjectPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.propertyChangeListener);
        BeansCorePlugin.unregisterNamespaceDefinitionListener(this.propertyChangeListener);
    }

    private class EnablementPropertyChangeListener
    implements Preferences.IPropertyChangeListener,
    IEclipsePreferences.IPreferenceChangeListener,
    INamespaceDefinitionListener {
        private static final String KEY = "org.springframework.ide.eclipse.beans.core.loadNamespaceHandlerFromClasspath";
        private final String nodePath;

        private EnablementPropertyChangeListener() {
            this.nodePath = "/project/" + ProjectClasspathNamespaceDefinitionResolver.this.project.getName() + "/" + "org.springframework.ide.eclipse.beans.core";
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (KEY.equals(event.getKey()) && this.nodePath.equals(event.getNode().absolutePath())) {
                ProjectClasspathNamespaceDefinitionResolver.this.init();
            }
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if ("loadNamespaceHandlerFromClasspath".equals(event.getProperty())) {
                ProjectClasspathNamespaceDefinitionResolver.this.init();
            }
        }

        @Override
        public void onNamespaceDefinitionRegistered(INamespaceDefinitionListener.NamespaceDefinitionChangeEvent event) {
            if (!NamespaceUtils.useNamespacesFromClasspath(ProjectClasspathNamespaceDefinitionResolver.this.project)) {
                ProjectClasspathNamespaceDefinitionResolver.this.init();
            }
        }

        @Override
        public void onNamespaceDefinitionUnregistered(INamespaceDefinitionListener.NamespaceDefinitionChangeEvent event) {
            if (!NamespaceUtils.useNamespacesFromClasspath(ProjectClasspathNamespaceDefinitionResolver.this.project)) {
                ProjectClasspathNamespaceDefinitionResolver.this.init();
            }
        }
    }

    private class ExternalImageNamespaceDefinition
    extends NamespaceDefinition {
        private final File iconFile;

        public ExternalImageNamespaceDefinition(Properties uriMapping, File iconFile) {
            super(uriMapping);
            this.iconFile = iconFile;
        }

        @Override
        public InputStream getIconStream() {
            if (this.iconFile != null && this.iconFile.exists() && this.iconFile.canRead()) {
                try {
                    return new FileInputStream(this.iconFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            return null;
        }
    }
}

