/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigFactory;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionReader;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionWriter;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigEventListener;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorDefinition;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.beans.core.model.locate.IBeansConfigLocator;
import org.springframework.ide.eclipse.beans.core.model.locate.IJavaConfigLocator;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessor;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.model.AbstractModel;
import org.springframework.ide.eclipse.core.model.AbstractResourceModelElement;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.util.ObjectUtils;

public class BeansProject
extends AbstractResourceModelElement
implements IBeansProject,
ILazyInitializedModelElement {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    protected volatile boolean modelPopulated = false;
    private final IProject project;
    protected volatile Set<String> configSuffixes = new LinkedHashSet<String>();
    protected volatile boolean isImportsEnabled = false;
    protected volatile String version = "2.0.0";
    protected volatile Map<String, IBeansConfig> configs = new LinkedHashMap<String, IBeansConfig>();
    protected volatile Map<String, IBeansConfig> autoDetectedConfigs = new LinkedHashMap<String, IBeansConfig>();
    protected volatile Set<IBeansConfig> allConfigs = Collections.unmodifiableSet(new CopyOnWriteArraySet());
    protected volatile Map<String, Set<String>> autoDetectedConfigsByLocator = new LinkedHashMap<String, Set<String>>();
    protected volatile Map<String, String> locatorByAutoDetectedConfig = new LinkedHashMap<String, String>();
    protected volatile Map<String, IBeansConfigSet> configSets = new LinkedHashMap<String, IBeansConfigSet>();
    protected volatile Map<String, IBeansConfigSet> autoDetectedConfigSets = new LinkedHashMap<String, IBeansConfigSet>();
    protected volatile Map<String, String> autoDetectedConfigSetsByLocator = new LinkedHashMap<String, String>();
    protected volatile IBeansConfigEventListener eventListener;
    private boolean isAutoConfigStatePersisted = false;

    public BeansProject(IBeansModel model, IProject project) {
        super((IModelElement)model, project.getName());
        this.project = project;
    }

    public int getElementType() {
        return 2;
    }

    public IModelElement[] getElementChildren() {
        LinkedHashSet<IBeansConfig> children = new LinkedHashSet<IBeansConfig>(this.getConfigs());
        children.addAll(this.getConfigSets());
        return children.toArray(new IModelElement[children.size()]);
    }

    public IResource getElementResource() {
        return this.project;
    }

    public boolean isElementArchived() {
        return false;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IBeansConfig config : this.getConfigs()) {
                config.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBeansConfigSet configSet : this.getConfigSets()) {
                configSet.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public void setConfigSuffixes(Set<String> suffixes) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.w.lock();
            this.configSuffixes.clear();
            this.configSuffixes.addAll(suffixes);
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean addConfigSuffix(String suffix) {
        if (suffix != null && suffix.length() > 0) {
            if (!this.modelPopulated) {
                this.populateModel();
            }
            try {
                this.w.lock();
                if (!this.configSuffixes.contains(suffix)) {
                    this.configSuffixes.add(suffix);
                    return true;
                }
            }
            finally {
                this.w.unlock();
            }
        }
        return false;
    }

    @Override
    public Set<String> getConfigSuffixes() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            Set<String> set = Collections.unmodifiableSet(this.configSuffixes);
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    @Deprecated
    public Set<String> getConfigExtensions() {
        return this.getConfigSuffixes();
    }

    @Override
    public boolean hasConfigSuffix(String suffix) {
        try {
            this.r.lock();
            boolean bl = this.getConfigSuffixes().contains(suffix);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    @Deprecated
    public boolean hasConfigExtension(String extension) {
        return this.hasConfigSuffix(extension);
    }

    public void setConfigs(Set<String> configNames) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        ArrayList<IResource> deleteMarkersFrom = new ArrayList<IResource>();
        try {
            this.w.lock();
            for (IBeansConfig config : this.configs.values()) {
                String configName = config.getElementName();
                if (configNames.contains(configName)) continue;
                this.removeConfig(configName);
                deleteMarkersFrom.add(config.getElementResource());
            }
            this.configs.clear();
            for (String configName : configNames) {
                this.configs.put(configName, BeansConfigFactory.create(this, configName, IBeansConfig.Type.MANUAL));
            }
        }
        finally {
            this.updateAllConfigsCache();
            this.w.unlock();
        }
        for (IResource configResource : deleteMarkersFrom) {
            MarkerUtils.deleteMarkers((IResource)configResource, (String)"org.springframework.ide.eclipse.core.problemmarker");
        }
    }

    public boolean addConfig(IFile file, IBeansConfig.Type type) {
        return this.addConfig(this.getConfigName(file), type);
    }

    public boolean addConfig(String configName, IBeansConfig.Type type) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.w.lock();
            if (configName.length() > 0 && !this.configs.containsKey(configName)) {
                if (type == IBeansConfig.Type.MANUAL) {
                    IBeansConfig config = BeansConfigFactory.create(this, configName, type);
                    this.addConfig(config);
                    return true;
                }
                if (type == IBeansConfig.Type.AUTO_DETECTED && !this.autoDetectedConfigs.containsKey(configName)) {
                    this.populateAutoDetectedConfigsAndConfigSets(null);
                    return true;
                }
            }
        }
        finally {
            this.updateAllConfigsCache();
            this.w.unlock();
        }
        return false;
    }

    private boolean addConfig(IBeansConfig config) {
        String configName = config.getElementName();
        if (this.configs.containsKey(configName)) {
            return false;
        }
        this.configs.put(configName, config);
        config.registerEventListener(this.eventListener);
        if (this.autoDetectedConfigs.containsKey(configName)) {
            this.autoDetectedConfigs.remove(configName);
            String locatorId = this.locatorByAutoDetectedConfig.remove(configName);
            if (locatorId != null && this.autoDetectedConfigsByLocator.containsKey(locatorId)) {
                this.autoDetectedConfigsByLocator.get(locatorId).remove(configName);
            }
        }
        return true;
    }

    public boolean removeConfig(IFile file) {
        if (file.getProject().equals((Object)this.project)) {
            return this.removeConfig(this.getConfigName(file));
        }
        return this.removeConfigFromConfigSets(this.getConfigName(file));
    }

    public boolean removeConfig(String configName) {
        if (this.hasConfig(configName)) {
            try {
                String locatorId;
                this.w.lock();
                IBeansConfig config = this.configs.remove(configName);
                IBeansConfig autoDetectedConfig = this.autoDetectedConfigs.remove(configName);
                if (config != null) {
                    config.unregisterEventListener(this.eventListener);
                }
                if (autoDetectedConfig != null) {
                    autoDetectedConfig.unregisterEventListener(this.eventListener);
                }
                if ((locatorId = this.locatorByAutoDetectedConfig.remove(configName)) != null && this.autoDetectedConfigsByLocator.containsKey(locatorId)) {
                    this.autoDetectedConfigsByLocator.get(locatorId).remove(configName);
                }
            }
            finally {
                this.updateAllConfigsCache();
                this.w.unlock();
            }
            this.removeConfigFromConfigSets(configName);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConfig(IFile file) {
        return this.hasConfig(this.getConfigName(file));
    }

    @Override
    public boolean hasConfig(String configName) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            boolean bl = this.configs.containsKey(configName) || this.autoDetectedConfigs.containsKey(configName);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean hasConfig(IFile configFile, String configName, boolean includeImported) {
        if (this.hasConfig(configName)) {
            return true;
        }
        for (IBeansConfig config : this.getConfigs()) {
            if (config.getElementResource() == null || !config.getElementResource().equals((Object)configFile)) continue;
            return true;
        }
        if (this.isImportsEnabled() && includeImported) {
            try {
                this.r.lock();
                for (IBeansConfig bc : this.getConfigs()) {
                    if (!this.hasImportedBeansConfig(configFile, bc)) continue;
                    return true;
                }
            }
            finally {
                this.r.unlock();
            }
        }
        return false;
    }

    @Override
    public IBeansConfig getConfig(IFile configFile, boolean includeImported) {
        Set<IBeansConfig> beansConfigs = this.getConfigs(configFile, includeImported);
        Iterator<IBeansConfig> iterator = beansConfigs.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public Set<IBeansConfig> getConfigs(IFile file, boolean includeImported) {
        Set<IBeansConfig> ownConfigs;
        IBeansProject otherBeansProject;
        LinkedHashSet<IBeansConfig> beansConfigs = new LinkedHashSet<IBeansConfig>();
        if (file.getProject() != null && !this.project.equals((Object)file.getProject()) && (otherBeansProject = BeansCorePlugin.getModel().getProject(file.getProject())) != null) {
            Set<IBeansConfig> otherProjectConfigs = otherBeansProject.getConfigs(file, false);
            for (IBeansConfig otherProjectConfig : otherProjectConfigs) {
                beansConfigs.add(otherProjectConfig);
            }
        }
        if ((ownConfigs = this.getConfigs()) != null) {
            for (IBeansConfig config : ownConfigs) {
                if (config.getElementResource() == null || !config.getElementResource().equals((Object)file)) continue;
                beansConfigs.add(config);
            }
        }
        if (this.isImportsEnabled() && includeImported) {
            try {
                this.r.lock();
                if (ownConfigs != null) {
                    for (IBeansConfig bc : ownConfigs) {
                        this.checkForImportedBeansConfig(file, bc, beansConfigs);
                    }
                }
            }
            finally {
                this.r.unlock();
            }
        }
        return beansConfigs;
    }

    private void checkForImportedBeansConfig(IFile file, IBeansConfig bc, Set<IBeansConfig> beansConfigs) {
        if (bc.getElementResource() != null && bc.getElementResource().equals((Object)file)) {
            beansConfigs.add(bc);
        }
        for (IBeansImport bi : bc.getImports()) {
            for (IBeansConfig iBeansConfig : bi.getImportedBeansConfigs()) {
                this.checkForImportedBeansConfig(file, iBeansConfig, beansConfigs);
            }
        }
    }

    private boolean hasImportedBeansConfig(IFile file, IBeansConfig bc) {
        if (bc.getElementResource() != null && bc.getElementResource().equals((Object)file)) {
            return true;
        }
        for (IBeansImport bi : bc.getImports()) {
            for (IBeansConfig iBeansConfig : bi.getImportedBeansConfigs()) {
                if (!this.hasImportedBeansConfig(file, iBeansConfig)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IBeansConfig getConfig(IFile file) {
        IBeansConfig config = this.getConfig(this.getConfigName(file));
        if (config == null) {
            if (!this.modelPopulated) {
                this.populateModel();
            }
            try {
                this.r.lock();
                for (IBeansConfig beansConfig : this.configs.values()) {
                    if (beansConfig.getElementResource() == null || !beansConfig.getElementResource().equals((Object)file)) continue;
                    IBeansConfig iBeansConfig = beansConfig;
                    return iBeansConfig;
                }
            }
            finally {
                this.r.unlock();
            }
        }
        return config;
    }

    @Override
    public IBeansConfig getConfig(String configName) {
        if (configName != null && configName.length() > 0 && configName.charAt(0) == '/') {
            return BeansCorePlugin.getModel().getConfig(configName);
        }
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            if (this.configs.containsKey(configName)) {
                IBeansConfig iBeansConfig = this.configs.get(configName);
                return iBeansConfig;
            }
            if (this.autoDetectedConfigs.containsKey(configName)) {
                IBeansConfig iBeansConfig = this.autoDetectedConfigs.get(configName);
                return iBeansConfig;
            }
            return null;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<String> getConfigNames() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<String> configNames = new LinkedHashSet<String>(this.configs.keySet());
            configNames.addAll(this.autoDetectedConfigs.keySet());
            LinkedHashSet<String> linkedHashSet = configNames;
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<String> getManualConfigNames() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.configs.keySet());
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<String> getAutoConfigNames() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.autoDetectedConfigs.keySet());
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<String> getManualConfigSetNames() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.configSets.keySet());
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    public Set<String> getAutoConfigSetNames() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.autoDetectedConfigSets.keySet());
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<IBeansConfig> getConfigs() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            Set<IBeansConfig> set = this.allConfigs;
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setConfigSets(Set<IBeansConfigSet> configSets) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.w.lock();
            this.configSets.clear();
            for (IBeansConfigSet configSet : configSets) {
                this.configSets.put(configSet.getElementName(), configSet);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean addConfigSet(IBeansConfigSet configSet) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            if (!this.configSets.values().contains(configSet)) {
                this.configSets.put(configSet.getElementName(), configSet);
                if (this.autoDetectedConfigSets.containsKey(configSet.getElementName())) {
                    this.autoDetectedConfigSets.remove(configSet.getElementName());
                    this.autoDetectedConfigSetsByLocator.remove(configSet.getElementName());
                }
                return true;
            }
        }
        finally {
            this.r.unlock();
        }
        return false;
    }

    public void removeConfigSet(String configSetName) {
        try {
            this.w.lock();
            this.configSets.remove(configSetName);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public boolean hasConfigSet(String configSetName) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            boolean bl = this.configSets.containsKey(configSetName);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public IBeansConfigSet getConfigSet(String configSetName) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            IBeansConfigSet set = this.configSets.get(configSetName);
            if (set != null) {
                IBeansConfigSet iBeansConfigSet = set;
                return iBeansConfigSet;
            }
            IBeansConfigSet iBeansConfigSet = this.autoDetectedConfigSets.get(configSetName);
            return iBeansConfigSet;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<IBeansConfigSet> getConfigSets() {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        try {
            this.r.lock();
            LinkedHashSet<IBeansConfigSet> configSets = new LinkedHashSet<IBeansConfigSet>(this.configSets.values());
            configSets.addAll(this.autoDetectedConfigSets.values());
            LinkedHashSet<IBeansConfigSet> linkedHashSet = configSets;
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean isBeanClass(String className) {
        for (IBeansConfig config : this.getConfigs()) {
            if (!config.isBeanClass(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBeanClasses() {
        LinkedHashSet<String> beanClasses = new LinkedHashSet<String>();
        for (IBeansConfig config : this.getConfigs()) {
            beanClasses.addAll(config.getBeanClasses());
        }
        return beanClasses;
    }

    @Override
    public Set<IBean> getBeans(String className) {
        LinkedHashSet<IBean> beans = new LinkedHashSet<IBean>();
        for (IBeansConfig config : this.getConfigs()) {
            if (!config.isBeanClass(className)) continue;
            beans.addAll(config.getBeans(className));
        }
        return beans;
    }

    public void saveDescription() {
        BeansProjectDescriptionWriter.write(this);
    }

    public void reset() {
        try {
            this.w.lock();
            this.modelPopulated = false;
            this.configSuffixes.clear();
            this.configs.clear();
            this.configSets.clear();
            this.autoDetectedConfigs.clear();
            this.autoDetectedConfigsByLocator.clear();
            this.locatorByAutoDetectedConfig.clear();
            this.autoDetectedConfigSets.clear();
            this.autoDetectedConfigSetsByLocator.clear();
        }
        finally {
            this.updateAllConfigsCache();
            this.w.unlock();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansProject)) {
            return false;
        }
        BeansProject that = (BeansProject)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.project, (Object)that.project)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.project);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        try {
            this.r.lock();
            String string = "Project=" + this.getElementName() + ", ConfigExtensions=" + this.configSuffixes + ", Configs=" + this.configs.values() + ", ConfigsSets=" + this.configSets;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean isImportsEnabled() {
        return this.isImportsEnabled;
    }

    public void setImportsEnabled(boolean importEnabled) {
        this.isImportsEnabled = importEnabled;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isUpdatable() {
        IFile file = this.project.getProject().getFile((IPath)new Path(".springBeans"));
        return !file.isReadOnly();
    }

    public void removeAutoDetectedConfigs(String locatorId) {
        try {
            this.w.lock();
            Set<String> configs = this.autoDetectedConfigsByLocator.get(locatorId);
            if (configs != null) {
                this.autoDetectedConfigsByLocator.remove(locatorId);
            }
            if (configs != null) {
                for (String configName : configs) {
                    MarkerUtils.deleteAllMarkers((IResource)this.getConfig(configName).getElementResource(), (String)"org.springframework.ide.eclipse.core.problemmarker");
                    this.autoDetectedConfigs.remove(configName);
                    this.locatorByAutoDetectedConfig.remove(configName);
                }
            }
            String configSet = this.autoDetectedConfigSetsByLocator.get(locatorId);
            if (this.configSets != null) {
                this.autoDetectedConfigSets.remove(configSet);
                this.autoDetectedConfigSetsByLocator.remove(configSet);
            }
        }
        finally {
            this.updateAllConfigsCache();
            this.w.unlock();
        }
    }

    public boolean isExternal() {
        return false;
    }

    private boolean removeConfigFromConfigSets(String configName) {
        if (!this.modelPopulated) {
            this.populateModel();
        }
        boolean hasRemoved = false;
        try {
            this.r.lock();
            for (IBeansConfigSet configSet : this.configSets.values()) {
                if (!configSet.hasConfig(configName)) continue;
                ((BeansConfigSet)configSet).removeConfig(configName);
                hasRemoved = true;
            }
            for (IBeansConfigSet configSet : this.autoDetectedConfigSets.values()) {
                if (!configSet.hasConfig(configName)) continue;
                ((BeansConfigSet)configSet).removeConfig(configName);
                hasRemoved = true;
            }
        }
        finally {
            this.r.unlock();
        }
        return hasRemoved;
    }

    private String getConfigName(IFile file) {
        return BeansConfigFactory.getConfigName(file, this.project);
    }

    private void populateModel() {
        try {
            this.w.lock();
            if (this.modelPopulated) {
                return;
            }
            this.eventListener = new DefaultBeansConfigEventListener();
            this.modelPopulated = true;
            BeansProjectDescriptionReader.read(this);
            LinkedHashSet<IBeansConfig> configuredConfigs = new LinkedHashSet<IBeansConfig>(this.configs.values());
            for (IBeansConfig config : configuredConfigs) {
                if (config.getElementResource() != null && config.getElementResource().exists()) continue;
                this.removeConfig(config.getElementName());
            }
            HashMap<IBeansConfigSet, Set<String>> removedConfigsFromSets = new HashMap<IBeansConfigSet, Set<String>>();
            IBeansModel model = BeansCorePlugin.getModel();
            for (IBeansConfigSet configSet : this.configSets.values()) {
                for (String configName : configSet.getConfigNames()) {
                    if (this.hasConfig(configName) || model.getConfig(configName) != null) continue;
                    ((BeansConfigSet)configSet).removeConfig(configName);
                    HashSet<String> removedConfigs = (HashSet<String>)removedConfigsFromSets.get(configSet);
                    if (removedConfigs == null) {
                        removedConfigs = new HashSet<String>();
                        removedConfigsFromSets.put(configSet, removedConfigs);
                    }
                    removedConfigs.add(configName);
                }
            }
            this.populateAutoDetectedConfigsAndConfigSets(removedConfigsFromSets);
            for (IBeansConfig config : this.configs.values()) {
                config.registerEventListener(this.eventListener);
            }
        }
        finally {
            this.updateAllConfigsCache();
            this.w.unlock();
        }
    }

    protected void populateAutoDetectedConfigsAndConfigSets(final Map<IBeansConfigSet, Set<String>> removedConfigsFromSets) {
        if (BeansCorePlugin.getDefault().isAutoDetectionEnabled()) {
            Job job = new Job("populate auto detected configs"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        BeansProject.this.populateAutoDetectedConfigsAndConfigSetsInternally();
                        BeansProject.this.w.lock();
                        BeansProject.this.restoreConfigSetState(removedConfigsFromSets);
                    }
                    finally {
                        BeansProject.this.updateAllConfigsCache();
                        BeansProject.this.w.unlock();
                    }
                    ((AbstractModel)BeansCorePlugin.getModel()).notifyListeners((IModelElement)BeansProject.this, ModelChangeEvent.Type.CHANGED);
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family.equals("populateAutoConfigsJobFamily");
                }
            };
            job.setPriority(40);
            job.setRule(MultiRule.combine((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), (ISchedulingRule)BeansCoreUtils.BEANS_MODEL_INIT_RULE));
            job.schedule();
        }
    }

    protected void populateAutoDetectedConfigsAndConfigSetsInternally() {
        HashMap<BeansConfigLocatorDefinition, Map<String, IBeansConfig>> newAutoConfigs = new HashMap<BeansConfigLocatorDefinition, Map<String, IBeansConfig>>();
        final HashMap<BeansConfigLocatorDefinition, String> newConfigSetNames = new HashMap<BeansConfigLocatorDefinition, String>();
        for (final BeansConfigLocatorDefinition locator : BeansConfigLocatorFactory.getBeansConfigLocatorDefinitions()) {
            if (!locator.isEnabled(this.getProject()) || !locator.getBeansConfigLocator().supports(this.getProject())) continue;
            final HashMap detectedConfigs = new HashMap();
            newAutoConfigs.put(locator, detectedConfigs);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    String configSet;
                    IBeansConfigLocator configLocator = locator.getBeansConfigLocator();
                    Set<IFile> files = configLocator.locateBeansConfigs(BeansProject.this.getProject(), null);
                    for (IFile file : files) {
                        BeansConfig config = new BeansConfig(BeansProject.this, file.getProjectRelativePath().toString(), IBeansConfig.Type.AUTO_DETECTED);
                        String configName = BeansProject.this.getConfigName(file);
                        if (BeansProject.this.hasConfig(configName)) continue;
                        detectedConfigs.put(configName, config);
                    }
                    if (files.size() > 1 && (configSet = locator.getBeansConfigLocator().getBeansConfigSetName(files)).length() > 0) {
                        newConfigSetNames.put(locator, configSet);
                    }
                    if (configLocator instanceof IJavaConfigLocator) {
                        Set<IType> types = ((IJavaConfigLocator)configLocator).locateJavaConfigs(BeansProject.this.getProject(), null);
                        for (IType type : types) {
                            BeansJavaConfig config = new BeansJavaConfig(BeansProject.this, type, type.getFullyQualifiedName(), IBeansConfig.Type.AUTO_DETECTED);
                            String configName = "java:" + type.getFullyQualifiedName();
                            if (BeansProject.this.hasConfig(configName)) continue;
                            detectedConfigs.put(configName, config);
                        }
                    }
                }
            });
        }
        this.setAutoDetectedConfigs(newAutoConfigs, newConfigSetNames);
    }

    protected void setAutoDetectedConfigs(Map<BeansConfigLocatorDefinition, Map<String, IBeansConfig>> newAutoConfigs, Map<BeansConfigLocatorDefinition, String> newConfigSetNames) {
        try {
            this.w.lock();
            for (IBeansConfig config : this.autoDetectedConfigs.values()) {
                config.unregisterEventListener(this.eventListener);
            }
            this.autoDetectedConfigs.clear();
            this.autoDetectedConfigsByLocator.clear();
            this.locatorByAutoDetectedConfig.clear();
            this.autoDetectedConfigSets.clear();
            this.autoDetectedConfigSetsByLocator.clear();
            for (BeansConfigLocatorDefinition locator : newAutoConfigs.keySet()) {
                Map<String, IBeansConfig> detectedConfigs = newAutoConfigs.get((Object)locator);
                String configSetName = newConfigSetNames.get((Object)locator);
                if (detectedConfigs.size() <= 0) continue;
                LinkedHashSet<String> configNamesByLocator = new LinkedHashSet<String>();
                for (Map.Entry<String, IBeansConfig> detectedConfig : detectedConfigs.entrySet()) {
                    String configName = detectedConfig.getKey();
                    this.autoDetectedConfigs.put(configName, detectedConfig.getValue());
                    detectedConfig.getValue().registerEventListener(this.eventListener);
                    configNamesByLocator.add(configName);
                    this.locatorByAutoDetectedConfig.put(configName, String.valueOf(locator.getNamespaceUri()) + "." + locator.getId());
                }
                this.autoDetectedConfigsByLocator.put(String.valueOf(locator.getNamespaceUri()) + "." + locator.getId(), configNamesByLocator);
                if (configSetName == null || configSetName.length() <= 0) continue;
                BeansConfigSet configSet = new BeansConfigSet(this, configSetName, configNamesByLocator, IBeansConfigSet.Type.AUTO_DETECTED);
                locator.getBeansConfigLocator().configureBeansConfigSet(configSet);
                this.autoDetectedConfigSets.put(configSetName, configSet);
                this.autoDetectedConfigSetsByLocator.put(String.valueOf(locator.getNamespaceUri()) + "." + locator.getId(), configSetName);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    protected void restoreConfigSetState(Map<IBeansConfigSet, Set<String>> removedConfigsFromSets) {
        if (removedConfigsFromSets != null) {
            IBeansModel model = BeansCorePlugin.getModel();
            for (IBeansConfigSet configSet : removedConfigsFromSets.keySet()) {
                Set<String> removedConfigs = removedConfigsFromSets.get(configSet);
                for (String removedConfig : removedConfigs) {
                    if (!this.hasConfig(removedConfig) && model.getConfig(removedConfig) == null) continue;
                    ((BeansConfigSet)configSet).addConfig(removedConfig);
                }
            }
        }
    }

    protected void updateAllConfigsCache() {
        CopyOnWriteArraySet<IBeansConfig> newAllConfigs = new CopyOnWriteArraySet<IBeansConfig>(this.configs.values());
        newAllConfigs.addAll(this.autoDetectedConfigs.values());
        this.allConfigs = Collections.unmodifiableSet(newAllConfigs);
    }

    public boolean isInitialized() {
        if (!this.modelPopulated) {
            return false;
        }
        try {
            this.r.lock();
            for (IBeansConfig config : this.configs.values()) {
                if (((ILazyInitializedModelElement)config).isInitialized()) continue;
                return false;
            }
            for (IBeansConfig config : this.autoDetectedConfigs.values()) {
                if (((ILazyInitializedModelElement)config).isInitialized()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean isAutoConfigStatePersisted() {
        return this.isAutoConfigStatePersisted;
    }

    public void setAutoConfigStatePersisted(boolean autoConfigPersisted) {
        this.isAutoConfigStatePersisted = autoConfigPersisted;
    }

    class DefaultBeansConfigEventListener
    implements IBeansConfigEventListener {
        DefaultBeansConfigEventListener() {
        }

        @Override
        public void onPostProcessorDetected(IBeansConfig config, IBeansConfigPostProcessor postProcessor) {
            for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfigSet configSet : project.getConfigSets()) {
                    if (!configSet.hasConfig((IFile)config.getElementResource())) continue;
                    for (IBeansConfig configSetConfig : configSet.getConfigs()) {
                        if (configSetConfig.equals(config) || !(configSetConfig instanceof BeansConfig)) continue;
                        ((BeansConfig)configSetConfig).addExternalPostProcessor(postProcessor, config);
                    }
                }
            }
        }

        @Override
        public void onPostProcessorRemoved(IBeansConfig config, IBeansConfigPostProcessor postProcessor) {
            for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfigSet configSet : project.getConfigSets()) {
                    if (!configSet.hasConfig((IFile)config.getElementResource())) continue;
                    for (IBeansConfig configSetConfig : configSet.getConfigs()) {
                        if (configSetConfig.equals(config) || !(configSetConfig instanceof BeansConfig)) continue;
                        ((BeansConfig)configSetConfig).removeExternalPostProcessor(postProcessor, config);
                    }
                }
            }
        }

        @Override
        public void onReadEnd(IBeansConfig config) {
        }

        @Override
        public void onReadStart(IBeansConfig config) {
        }

        @Override
        public void onReset(IBeansConfig config) {
            for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfigSet configSet : project.getConfigSets()) {
                    if (!configSet.hasConfig((IFile)config.getElementResource()) || !(configSet instanceof BeansConfigSet)) continue;
                    ((BeansConfigSet)configSet).reset();
                }
            }
        }
    }
}

