/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.core.Entry;

public class CommandHistoryPopupList {
    public static LabelProvider defaultLabelProvider = new LabelProvider();
    private final Shell shell;
    private final List list;
    private Entry[] entries;
    private int minimumWidth;
    private boolean isAbove = true;
    private LabelProvider labelProvider = defaultLabelProvider;

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public CommandHistoryPopupList(Shell parent) {
        this(parent, 0);
    }

    public CommandHistoryPopupList(Shell parent, int style) {
        this.shell = new Shell(parent, CommandHistoryPopupList.checkStyle(style));
        this.list = new List((Composite)this.shell, 516);
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                CommandHistoryPopupList.this.shell.setVisible(false);
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle shellSize = CommandHistoryPopupList.this.shell.getClientArea();
                CommandHistoryPopupList.this.list.setSize(shellSize.width, shellSize.height);
            }
        });
        this.list.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                CommandHistoryPopupList.this.shell.setVisible(false);
            }
        });
        this.list.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    CommandHistoryPopupList.this.shell.setVisible(false);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public Entry[] getItems() {
        return this.entries;
    }

    private String getLabel(Entry entry) {
        return this.labelProvider.getLabel(entry);
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public Entry open(Rectangle rect) {
        Point listSize = this.list.computeSize(rect.width, -1, false);
        Rectangle screenSize = this.shell.getDisplay().getBounds();
        int spaceBelow = this.spaceBelow(rect, screenSize) - 30;
        int spaceAbove = this.spaceAbove(rect, screenSize) - 30;
        int y = 0;
        if (listSize.y <= spaceAbove) {
            this.setAbove(true);
            listSize.y = listSize.y > spaceAbove ? spaceAbove : (listSize.y += 2);
            y = rect.y - listSize.y;
        } else {
            this.setAbove(false);
            listSize.y = listSize.y > spaceBelow ? spaceBelow : (listSize.y += 2);
            y = rect.y + rect.height;
        }
        listSize.x = rect.width;
        if (listSize.x < this.minimumWidth) {
            listSize.x = this.minimumWidth;
        }
        int x = rect.x + rect.width - listSize.x;
        this.shell.setBounds(x, y, listSize.x, listSize.y);
        this.shell.open();
        this.list.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        Entry result = null;
        if (!this.shell.isDisposed()) {
            int selected = this.list.getSelectionIndex();
            this.shell.dispose();
            if (selected >= 0) {
                result = this.entries[this.isAbove ? this.entries.length - selected - 1 : selected];
            }
        }
        return result;
    }

    public void select(String string) {
        String[] items = this.list.getItems();
        if (string != null) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.startsWith(string)) {
                    int index = this.list.indexOf(item);
                    this.list.select(index);
                    break;
                }
                ++n2;
            }
        }
    }

    private void setAbove(boolean b) {
        if (this.isAbove != b) {
            this.isAbove = b;
            this.setItems(this.entries);
        }
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public void setItems(Entry[] entries) {
        this.entries = entries;
        String[] strings = new String[entries.length];
        int i = 0;
        while (i < strings.length) {
            strings[this.isAbove ? strings.length - i - 1 : i] = this.getLabel(entries[i]);
            ++i;
        }
        this.list.setItems(strings);
        this.list.select(this.isAbove ? strings.length - 1 : 0);
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setMinimumWidth(int width) {
        if (width < 0) {
            SWT.error((int)5);
        }
        this.minimumWidth = width;
    }

    private int spaceAbove(Rectangle rect, Rectangle screenSize) {
        int screenTop = screenSize.y;
        int rectTop = rect.y;
        return rectTop - screenTop;
    }

    private int spaceBelow(Rectangle rect, Rectangle screenSize) {
        int screenBottom = screenSize.y + screenSize.height;
        int rectBottom = rect.y + rect.height;
        return screenBottom - rectBottom;
    }

    public static class LabelProvider {
        public String getLabel(Entry entry) {
            return entry.getMenuLabel();
        }
    }
}

