/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.config.meta.RuleGroupMetadata;

public class RuleMetadata {
    private final String mName;
    private final String mInternalName;
    private final String mParent;
    private String mDescription;
    private final boolean mIsHidden;
    private final boolean mHasSeverity;
    private final boolean mIsDeletable;
    private final Severity mDefaultSeverityLevel;
    private final List<ConfigPropertyMetadata> mConfigPropMetadata = new LinkedList<ConfigPropertyMetadata>();
    private final RuleGroupMetadata mGroup;
    private final Collection<String> mAlternativeNames;
    private final Collection<String> mQuickfixes;
    private final Collection<String> mMessageKeys;
    private final boolean mIsSingleton;

    public RuleMetadata(String ruleName, String internalName, String parent, Severity defaultSeverity, boolean hidden, boolean hasSeverity, boolean deletable, boolean isSingleton, RuleGroupMetadata group) {
        this.mName = ruleName;
        this.mInternalName = internalName;
        this.mParent = parent;
        this.mDefaultSeverityLevel = defaultSeverity;
        this.mIsHidden = hidden;
        this.mHasSeverity = hasSeverity;
        this.mIsDeletable = deletable;
        this.mGroup = group;
        this.mAlternativeNames = new ArrayList<String>();
        this.mQuickfixes = new ArrayList<String>();
        this.mMessageKeys = new ArrayList<String>();
        this.mIsSingleton = isSingleton;
    }

    public void addAlternativeName(String alternativeName) {
        this.mAlternativeNames.add(alternativeName);
    }

    public Collection<String> getAlternativeNames() {
        return this.mAlternativeNames;
    }

    public void addQuickfix(String quickfixClassName) {
        this.mQuickfixes.add(quickfixClassName);
    }

    public Collection<String> getQuickfixClassNames() {
        return this.mQuickfixes;
    }

    public void addMessageKey(String messageKey) {
        this.mMessageKeys.add(messageKey);
    }

    public Collection<String> getMessageKeys() {
        return this.mMessageKeys;
    }

    public Severity getDefaultSeverityLevel() {
        return this.mDefaultSeverityLevel;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getRuleName() {
        return this.mName;
    }

    public String getInternalName() {
        return this.mInternalName;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public boolean hasSeverity() {
        return this.mHasSeverity;
    }

    public boolean isDeletable() {
        return this.mIsDeletable;
    }

    public boolean isSingleton() {
        return this.mIsSingleton;
    }

    public String getParentModule() {
        return this.mParent;
    }

    public List<ConfigPropertyMetadata> getPropertyMetadata() {
        return this.mConfigPropMetadata;
    }

    public ConfigPropertyMetadata getPropertyMetadata(String property) {
        ConfigPropertyMetadata propertyMeta = null;
        int size = this.mConfigPropMetadata != null ? this.mConfigPropMetadata.size() : 0;
        int i = 0;
        while (i < size) {
            ConfigPropertyMetadata tmp = this.mConfigPropMetadata.get(i);
            if (tmp.getName().equals(property)) {
                propertyMeta = tmp;
                break;
            }
            ++i;
        }
        return propertyMeta;
    }

    public RuleGroupMetadata getGroup() {
        return this.mGroup;
    }
}

