/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class RemoteConfigurationType
extends ConfigurationType {
    public static final String KEY_CACHE_CONFIG = "cache-file";
    public static final String KEY_CACHE_FILE_LOCATION = "cache-file-location";
    public static final String KEY_CACHE_PROPS_FILE_LOCATION = "cache-props-file-location";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    private static Set<String> sFailedWith401URLs = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        boolean useCacheFile = Boolean.valueOf(checkConfiguration.getAdditionalData().get(KEY_CACHE_CONFIG));
        CheckstyleConfigurationFile data = new CheckstyleConfigurationFile();
        Class<Authenticator> clazz = Authenticator.class;
        synchronized (Authenticator.class) {
            block27: {
                String currentRedirects = System.getProperty("http.maxRedirects");
                Authenticator oldAuthenticator = RemoteConfigAuthenticator.getDefault();
                try {
                    data.setResolvedConfigFileURL(this.resolveLocation(checkConfiguration));
                    Authenticator.setDefault(new RemoteConfigAuthenticator(data.getResolvedConfigFileURL()));
                    boolean originalFileSuccess = false;
                    byte[] configurationFileData = null;
                    try {
                        System.setProperty("http.maxRedirects", "3");
                        URLConnection connection = data.getResolvedConfigFileURL().openConnection();
                        configurationFileData = this.getBytesFromURLConnection(connection);
                        data.setModificationStamp(connection.getLastModified());
                        originalFileSuccess = true;
                    }
                    catch (IOException e) {
                        if (useCacheFile) {
                            configurationFileData = this.getBytesFromCacheFile(checkConfiguration);
                        }
                        throw e;
                    }
                    data.setCheckConfigFileBytes(configurationFileData);
                    byte[] additionalPropertiesBytes = null;
                    if (originalFileSuccess) {
                        additionalPropertiesBytes = this.getAdditionPropertiesBundleBytes(data.getResolvedConfigFileURL());
                    } else if (useCacheFile) {
                        additionalPropertiesBytes = this.getBytesFromCacheBundleFile(checkConfiguration);
                    }
                    data.setAdditionalPropertyBundleBytes(additionalPropertiesBytes);
                    PropertyResolver resolver = this.getPropertyResolver(checkConfiguration, data);
                    data.setPropertyResolver(resolver);
                    if (originalFileSuccess && useCacheFile) {
                        this.writeToCacheFile(checkConfiguration, configurationFileData, additionalPropertiesBytes);
                    }
                }
                catch (UnknownHostException e) {
                    CheckstylePluginException.rethrow(e, NLS.bind((String)Messages.RemoteConfigurationType_errorUnknownHost, (Object)e.getMessage()));
                    Authenticator.setDefault(oldAuthenticator);
                    if (currentRedirects != null) {
                        System.setProperty("http.maxRedirects", currentRedirects);
                    } else {
                        System.getProperties().remove("http.maxRedirects");
                    }
                    break block27;
                }
                catch (FileNotFoundException e) {
                    CheckstylePluginException.rethrow(e, NLS.bind((String)Messages.RemoteConfigurationType_errorFileNotFound, (Object)e.getMessage()));
                    break block27;
                }
                catch (IOException e) {
                    CheckstylePluginException.rethrow(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    Authenticator.setDefault(oldAuthenticator);
                    if (currentRedirects != null) {
                        System.setProperty("http.maxRedirects", currentRedirects);
                    } else {
                        System.getProperties().remove("http.maxRedirects");
                    }
                    break block27;
                }
                {
                    finally {
                        Authenticator.setDefault(oldAuthenticator);
                        if (currentRedirects != null) {
                            System.setProperty("http.maxRedirects", currentRedirects);
                        } else {
                            System.getProperties().remove("http.maxRedirects");
                        }
                    }
                }
                Authenticator.setDefault(oldAuthenticator);
                if (currentRedirects != null) {
                    System.setProperty("http.maxRedirects", currentRedirects);
                } else {
                    System.getProperties().remove("http.maxRedirects");
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return data;
        }
    }

    @Override
    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        return new URL(checkConfiguration.getLocation());
    }

    @Override
    public void notifyCheckConfigRemoved(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        super.notifyCheckConfigRemoved(checkConfiguration);
        RemoteConfigAuthenticator.removeCachedAuthInfo(checkConfiguration.getResolvedConfigurationFileURL());
        boolean useCacheFile = Boolean.valueOf(checkConfiguration.getAdditionalData().get(KEY_CACHE_CONFIG));
        if (useCacheFile) {
            String cacheFileLocation = checkConfiguration.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
            IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            cacheFilePath = cacheFilePath.append(cacheFileLocation);
            File cacheFile = cacheFilePath.toFile();
            cacheFile.delete();
        }
    }

    private byte[] getBytesFromCacheFile(ICheckConfiguration checkConfig) throws IOException {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
        IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
        cacheFilePath = cacheFilePath.append(cacheFileLocation);
        File cacheFile = cacheFilePath.toFile();
        URL configURL = cacheFile.toURI().toURL();
        URLConnection connection = configURL.openConnection();
        return this.getBytesFromURLConnection(connection);
    }

    private byte[] getBytesFromCacheBundleFile(ICheckConfiguration checkConfig) {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_PROPS_FILE_LOCATION);
        if (cacheFileLocation == null) {
            return null;
        }
        try {
            IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            cacheFilePath = cacheFilePath.append(cacheFileLocation);
            File cacheFile = cacheFilePath.toFile();
            URL configURL = cacheFile.toURI().toURL();
            URLConnection connection = configURL.openConnection();
            return this.getBytesFromURLConnection(connection);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeToCacheFile(ICheckConfiguration checkConfig, byte[] configFileBytes, byte[] bundleBytes) {
        String cacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_FILE_LOCATION);
        IPath cacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
        cacheFilePath = cacheFilePath.append(cacheFileLocation);
        File cacheFile = cacheFilePath.toFile();
        try {
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])configFileBytes);
        }
        catch (IOException e) {
            CheckstyleLog.log(e, NLS.bind((String)Messages.RemoteConfigurationType_msgRemoteCachingFailed, (Object)checkConfig.getName(), (Object)checkConfig.getLocation()));
        }
        if (bundleBytes != null) {
            String propsCacheFileLocation = checkConfig.getAdditionalData().get(KEY_CACHE_PROPS_FILE_LOCATION);
            IPath propsCacheFilePath = CheckstylePlugin.getDefault().getStateLocation();
            propsCacheFilePath = propsCacheFilePath.append(propsCacheFileLocation);
            File propsCacheFile = propsCacheFilePath.toFile();
            try {
                FileUtils.writeByteArrayToFile((File)propsCacheFile, (byte[])bundleBytes);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected byte[] getBytesFromURLConnection(URLConnection connection) throws IOException {
        byte[] configurationFileData = null;
        InputStream in = null;
        try {
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            if (connection instanceof HttpURLConnection) {
                if (!sFailedWith401URLs.contains(connection.getURL().toString())) {
                    HttpURLConnection httpConn = (HttpURLConnection)connection;
                    httpConn.setInstanceFollowRedirects(true);
                    httpConn.connect();
                    if (httpConn.getResponseCode() == 401) {
                        try {
                            RemoteConfigAuthenticator.removeCachedAuthInfo(connection.getURL());
                        }
                        catch (CheckstylePluginException e) {
                            CheckstyleLog.log(e);
                        }
                        sFailedWith401URLs.add(connection.getURL().toString());
                        throw new IOException(Messages.RemoteConfigurationType_msgUnAuthorized);
                    }
                } else {
                    throw new IOException(Messages.RemoteConfigurationType_msgUnAuthorized);
                }
            }
            in = connection.getInputStream();
            configurationFileData = IOUtils.toByteArray((InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return configurationFileData;
    }

    public static class RemoteConfigAuthenticator
    extends Authenticator {
        private final URL mResolvedCheckConfigurationURL;

        public RemoteConfigAuthenticator(URL resolvedCheckConfigurationURL) {
            this.mResolvedCheckConfigurationURL = resolvedCheckConfigurationURL;
        }

        public static Authenticator getDefault() {
            Authenticator currentDefault = null;
            try {
                Field[] fields = Authenticator.class.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    if (Authenticator.class.equals(fields[i].getType())) {
                        fields[i].setAccessible(true);
                        currentDefault = (Authenticator)fields[i].get(Authenticator.class);
                        break;
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                CheckstyleLog.log(e);
            }
            catch (IllegalAccessException e) {
                CheckstyleLog.log(e);
            }
            return currentDefault;
        }

        public static void storeCredentials(URL resolvedCheckConfigurationURL, String userName, String password) {
            try {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL));
                prefs.put(RemoteConfigurationType.KEY_USERNAME, userName, false);
                prefs.put(RemoteConfigurationType.KEY_PASSWORD, password, true);
                sFailedWith401URLs.remove(resolvedCheckConfigurationURL.toString());
            }
            catch (CheckstylePluginException e) {
                CheckstyleLog.log(e);
            }
            catch (StorageException e) {
                CheckstyleLog.log(e);
            }
        }

        public static PasswordAuthentication getPasswordAuthentication(URL resolvedCheckConfigurationURL) {
            PasswordAuthentication auth = null;
            try {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL));
                String userName = prefs.get(RemoteConfigurationType.KEY_USERNAME, null);
                String password = prefs.get(RemoteConfigurationType.KEY_PASSWORD, null);
                if (userName != null && password != null) {
                    auth = new PasswordAuthentication(userName, password.toCharArray());
                }
            }
            catch (CheckstylePluginException e) {
                CheckstyleLog.log(e);
            }
            catch (StorageException e) {
                CheckstyleLog.log(e);
            }
            return auth;
        }

        public static void removeCachedAuthInfo(URL resolvedCheckConfigurationURL) throws CheckstylePluginException {
            sFailedWith401URLs.remove(resolvedCheckConfigurationURL.toString());
            String storagePath = RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL);
            if (SecurePreferencesFactory.getDefault().nodeExists(storagePath)) {
                ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteConfigAuthenticator.getSecureStoragePath(resolvedCheckConfigurationURL));
                prefs.removeNode();
            }
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return RemoteConfigAuthenticator.getPasswordAuthentication(this.mResolvedCheckConfigurationURL);
        }

        private static String getSecureStoragePath(URL resolvedCheckConfigurationURL) throws CheckstylePluginException {
            String urlHash = null;
            try {
                MessageDigest d = MessageDigest.getInstance("MD5");
                byte[] hash = d.digest(resolvedCheckConfigurationURL.toExternalForm().getBytes("UTF-8"));
                urlHash = EncodingUtils.encodeBase64((byte[])hash);
                urlHash = urlHash.replace('/', '_');
                urlHash = urlHash.replace('\\', '_');
            }
            catch (NoSuchAlgorithmException e) {
                CheckstylePluginException.rethrow(e);
            }
            catch (UnsupportedEncodingException e) {
                CheckstylePluginException.rethrow(e);
            }
            return "eclipse-cs/" + urlHash;
        }
    }
}

