/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.outline.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;

public class UtilUIImages {
    private static final String ICON_PATH_PREFIX = "";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.beans.ui.editor.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.beans.ui.editor.".length();
    private static final String STRUCTURE = "icons/full/obj16/";
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_PROPERTIES = "org.springframework.ide.eclipse.beans.ui.editor.properties_obj.gif";
    public static final String IMG_OBJS_SET = "org.springframework.ide.eclipse.beans.ui.editor.column_obj.gif";
    public static final String IMG_OBJS_LIST = "org.springframework.ide.eclipse.beans.ui.editor.column_obj.gif";
    public static final String IMG_OBJS_MAP = "org.springframework.ide.eclipse.beans.ui.editor.table_obj.gif";
    public static final String IMG_OBJS_CONSTANT = "org.springframework.ide.eclipse.beans.ui.editor.field_public_obj.gif";
    public static final ImageDescriptor DESC_OBJS_PROPERTIES;
    public static final ImageDescriptor DESC_OBJS_SET;
    public static final ImageDescriptor DESC_OBJS_LIST;
    public static final ImageDescriptor DESC_OBJS_MAP;
    public static final ImageDescriptor DESC_OBJS_CONSTANT;

    static {
        try {
            ICON_BASE_URL = new URL(Activator.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        DESC_OBJS_PROPERTIES = UtilUIImages.createManaged(STRUCTURE, IMG_OBJS_PROPERTIES);
        DESC_OBJS_SET = UtilUIImages.createManaged(STRUCTURE, "org.springframework.ide.eclipse.beans.ui.editor.column_obj.gif");
        DESC_OBJS_LIST = UtilUIImages.createManaged(STRUCTURE, "org.springframework.ide.eclipse.beans.ui.editor.column_obj.gif");
        DESC_OBJS_MAP = UtilUIImages.createManaged(STRUCTURE, IMG_OBJS_MAP);
        DESC_OBJS_CONSTANT = UtilUIImages.createManaged(STRUCTURE, IMG_OBJS_CONSTANT);
    }

    public static Image getImage(String key) {
        return UtilUIImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        UtilUIImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        UtilUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Iterator<String> iterator = imageDescriptors.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = iterator.next();
                imageRegistry.put(key, imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)UtilUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        action.setImageDescriptor(UtilUIImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)UtilUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                Activator.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)UtilUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

