/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Node;

public class InitDestroyMethodHyperlinkCalculator
implements IHyperlinkCalculator {
    @Override
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IFile file = BeansEditorUtils.getFile(document);
        String className = BeansEditorUtils.getClassNameForBean(file, node.getOwnerDocument(), node);
        if (file != null && file.exists()) {
            IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
            try {
                IMethod method = Introspector.findMethod((IType)type, (String)target, (int)-1, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE);
                if (method != null) {
                    return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }
}

