/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jbosspackaging.configurators;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class JBossPackagingPluginConfiguration {
    private static final String DEFAULT_LIB_DIRECTORY = "/lib";
    protected final MavenProject mavenProject;
    protected Set<String> excludes = null;
    protected Boolean excludeAll;
    protected Boolean removeDependencyVersions;
    protected Xpp3Dom configuration;
    protected String libDirectory;

    public JBossPackagingPluginConfiguration(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        Plugin plugin = mavenProject.getPlugin("org.codehaus.mojo:jboss-packaging-maven-plugin");
        if (plugin != null) {
            this.configuration = (Xpp3Dom)plugin.getConfiguration();
        }
    }

    public String getLibDirectory() {
        if (this.libDirectory == null) {
            Xpp3Dom libDom;
            if (this.configuration != null && (libDom = this.configuration.getChild("libDirectory")) != null) {
                this.libDirectory = libDom.getValue();
            }
            if (StringUtils.isEmpty((String)this.libDirectory)) {
                this.libDirectory = DEFAULT_LIB_DIRECTORY;
            }
        }
        return this.libDirectory;
    }

    public boolean isExcludeAll() {
        if (this.excludeAll == null) {
            Xpp3Dom excludeAllDom;
            if (this.configuration != null && (excludeAllDom = this.configuration.getChild("excludeAll")) != null) {
                this.excludeAll = Boolean.valueOf(excludeAllDom.getValue());
            }
            if (this.excludeAll == null) {
                this.excludeAll = Boolean.FALSE;
            }
        }
        return this.excludeAll;
    }

    public boolean isRemoveDependencyVersions() {
        if (this.removeDependencyVersions == null) {
            Xpp3Dom removeVersionDom;
            if (this.configuration != null && (removeVersionDom = this.configuration.getChild("removeDependencyVersions")) != null) {
                this.removeDependencyVersions = Boolean.valueOf(removeVersionDom.getValue());
            }
            if (this.removeDependencyVersions == null) {
                this.removeDependencyVersions = Boolean.FALSE;
            }
        }
        return this.removeDependencyVersions;
    }

    public boolean isExcluded(Artifact artifact) {
        if (this.isExcludeAll() || !artifact.getArtifactHandler().isAddedToClasspath()) {
            return true;
        }
        if (this.getExcludes() != null) {
            for (String groupIdArtifactId : this.excludes) {
                if (!groupIdArtifactId.equals(String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getExcludes() {
        if (this.excludes == null) {
            Xpp3Dom excludesDom;
            this.excludes = new HashSet<String>();
            if (this.configuration != null && (excludesDom = this.configuration.getChild("excludes")) != null) {
                Xpp3Dom[] xpp3DomArray = excludesDom.getChildren("exclude");
                int n = xpp3DomArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String exclude;
                    Xpp3Dom excludeDom = xpp3DomArray[n2];
                    if (excludeDom != null && StringUtils.isNotEmpty((String)(exclude = excludeDom.getValue()))) {
                        this.excludes.add(exclude);
                    }
                    ++n2;
                }
            }
        }
        return this.excludes;
    }

    public String mapFileName(Artifact artifact) {
        StringBuilder fileName = new StringBuilder(artifact.getArtifactId());
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            fileName.append("-").append(classifier);
        }
        if (!this.isRemoveDependencyVersions()) {
            fileName.append("-").append(artifact.getVersion());
        }
        fileName.append(".").append(artifact.getArtifactHandler().getExtension());
        return fileName.toString();
    }
}

