/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.quickfix.ContentAssistProposalWrapper;
import org.springframework.ide.eclipse.quickfix.QuickfixContentAssistConverter;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewMethodQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RenameToSimilarNameQuickFixProposal;

public class MethodAttributeQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final IDOMNode parentNode;
    private final IJavaProject javaProject;
    private final String className;
    private final boolean isStatic;
    private final IContentAssistCalculator calculator;
    private final IFile file;
    private final String attributeName;

    public MethodAttributeQuickAssistProcessor(int offset, int length, String className, String text, boolean missingEndQuote, IDOMNode parentNode, String attributeName, IProject project, boolean isStatic, IContentAssistCalculator calculator, IFile file) {
        super(offset, length, text, missingEndQuote);
        this.parentNode = parentNode;
        this.attributeName = attributeName;
        this.javaProject = JavaCore.create((IProject)project);
        this.className = className;
        this.isStatic = isStatic;
        this.calculator = calculator;
        this.file = file;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        CreateNewMethodQuickFixProposal createNewMethodQuickFixProposal;
        ArrayList<BeanAttributeQuickFixProposal> proposals = new ArrayList<BeanAttributeQuickFixProposal>();
        Set<ContentAssistProposalWrapper> matchedProposals = new QuickfixContentAssistConverter(this.parentNode, this.attributeName, this.file).getMethodProposals(this.text, false, this.calculator);
        for (ContentAssistProposalWrapper contentAssistProposalWrapper : matchedProposals) {
            String methodName = contentAssistProposalWrapper.getName();
            String description = contentAssistProposalWrapper.getDisplayText();
            proposals.add(new RenameToSimilarNameQuickFixProposal(methodName, this.offset, this.length, this.missingEndQuote, description));
        }
        if (this.className != null && (createNewMethodQuickFixProposal = QuickfixUtils.getNewMethodQuickFixProposal(this.text, "Object", new String[0], this.javaProject, this.className, this.offset, this.length, this.text, this.missingEndQuote, this.isStatic, "method")) != null) {
            proposals.add(createNewMethodQuickFixProposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

