/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.ConfigurationLocationProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.PackageNameProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.QualifierArgumentProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.QualifierCompletionProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.RequestMappingParamTypeProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.RequestMappingVariableProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.SimpleClassProposalComputer;

public class AnnotationComputerRegistry {
    public static JavaCompletionProposalComputer[] computers = new JavaCompletionProposalComputer[]{new QualifierCompletionProposalComputer(), new RequestMappingParamTypeProposalComputer(), new ConfigurationLocationProposalComputer(), new SimpleClassProposalComputer()};
    public static final String DEFAULT_ATTRIBUTE_NAME = "value";
    public static Map<String, Map<String, Set<AnnotationProposalComputer>>> annotationArgComputers = null;
    public static Map<String, Map<String, Set<AnnotationProposalComputer>>> annotationArgComputersForArray = null;

    private static void init() {
        annotationArgComputers = new HashMap<String, Map<String, Set<AnnotationProposalComputer>>>();
        annotationArgComputersForArray = new HashMap<String, Map<String, Set<AnnotationProposalComputer>>>();
        AnnotationComputerRegistry.addProposalComputer("Qualifier", new QualifierArgumentProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("RequestMapping", new RequestMappingVariableProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("ContextConfiguration", "locations", new ConfigurationLocationProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("ContextConfiguration", DEFAULT_ATTRIBUTE_NAME, new ConfigurationLocationProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("ComponentScan", new PackageNameProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("ComponentScan", "basePackages", new PackageNameProposalComputer());
        AnnotationComputerRegistry.addProposalComputer("ComponentScan", "basePackageClasses", new SimpleClassProposalComputer());
        AnnotationComputerRegistry.addProposalComputerForArrayAttribute("ComponentScan", new PackageNameProposalComputer());
        AnnotationComputerRegistry.addProposalComputerForArrayAttribute("ComponentScan", "basePackages", new PackageNameProposalComputer());
        AnnotationComputerRegistry.addProposalComputerForArrayAttribute("ComponentScan", "basePackageClasses", new SimpleClassProposalComputer());
    }

    private static void addProposalComputer(String annotationName, AnnotationProposalComputer proposalComputer) {
        AnnotationComputerRegistry.addProposalComputer(annotationName, DEFAULT_ATTRIBUTE_NAME, proposalComputer);
    }

    private static void addProposalComputerForArrayAttribute(String annotationName, AnnotationProposalComputer proposalComputer) {
        AnnotationComputerRegistry.addProposalComputerForArrayAttribute(annotationName, DEFAULT_ATTRIBUTE_NAME, proposalComputer);
    }

    private static void addProposalComputer(String annotationName, String attributeName, AnnotationProposalComputer proposalComputer) {
        AnnotationComputerRegistry.addProposalComputerHelper(annotationName, attributeName, proposalComputer, annotationArgComputers);
    }

    private static void addProposalComputerForArrayAttribute(String annotationName, String attributeName, AnnotationProposalComputer proposalComputer) {
        AnnotationComputerRegistry.addProposalComputerHelper(annotationName, attributeName, proposalComputer, annotationArgComputersForArray);
    }

    private static void addProposalComputerHelper(String annotationName, String attributeName, AnnotationProposalComputer proposalComputer, Map<String, Map<String, Set<AnnotationProposalComputer>>> map) {
        if (map != null) {
            Set<AnnotationProposalComputer> computers;
            Map<String, Set<AnnotationProposalComputer>> attributeToComputers = map.get(annotationName);
            if (attributeToComputers == null) {
                attributeToComputers = new HashMap<String, Set<AnnotationProposalComputer>>();
                map.put(annotationName, attributeToComputers);
            }
            if ((computers = attributeToComputers.get(attributeName)) == null) {
                computers = new HashSet<AnnotationProposalComputer>();
                attributeToComputers.put(attributeName, computers);
            }
            computers.add(proposalComputer);
        }
    }

    public static Set<AnnotationProposalComputer> getProposalComputer(String annotationName) {
        return AnnotationComputerRegistry.getProposalComputer(annotationName, DEFAULT_ATTRIBUTE_NAME);
    }

    public static Set<AnnotationProposalComputer> getProposalComputer(String annotationName, String attributeName) {
        if (annotationArgComputers == null) {
            AnnotationComputerRegistry.init();
        }
        return AnnotationComputerRegistry.getProposalComputerHelper(annotationName, attributeName, annotationArgComputers);
    }

    public static Set<AnnotationProposalComputer> getProposalComputerForArrayAttribute(String annotationName) {
        return AnnotationComputerRegistry.getProposalComputerForArrayAttribute(annotationName, DEFAULT_ATTRIBUTE_NAME);
    }

    public static Set<AnnotationProposalComputer> getProposalComputerForArrayAttribute(String annotationName, String attributeName) {
        if (annotationArgComputersForArray == null) {
            AnnotationComputerRegistry.init();
        }
        return AnnotationComputerRegistry.getProposalComputerHelper(annotationName, attributeName, annotationArgComputersForArray);
    }

    private static Set<AnnotationProposalComputer> getProposalComputerHelper(String annotationName, String attributeName, Map<String, Map<String, Set<AnnotationProposalComputer>>> map) {
        Set<AnnotationProposalComputer> result;
        Map<String, Set<AnnotationProposalComputer>> attributeToComputers = map.get(annotationName);
        if (attributeToComputers != null && (result = attributeToComputers.get(attributeName)) != null) {
            return result;
        }
        return Collections.emptySet();
    }
}

