/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.QuickfixAnnotationInfo;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidatorVisitor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansEditorValidator
implements ISourceValidator,
IValidator {
    private IDocument document = null;
    private IFile file = null;
    private IStructuredModel model = null;
    private IProject project;

    private void addCheckedNodes(IDOMNode node, Set<IDOMNode> checkedNodes) {
        checkedNodes.add(node);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child instanceof IDOMNode) {
                this.addCheckedNodes((IDOMNode)child, checkedNodes);
            }
            ++i;
        }
    }

    public void cleanup(IReporter reporter) {
        reporter.removeAllMessages((IValidator)this);
    }

    public void connect(IDocument document) {
        this.document = document;
        if (this.model == null) {
            this.model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        }
        if (this.model != null) {
            String location = this.model.getBaseLocation();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(location);
            if (root.getFullPath().append((IPath)filePath).segmentCount() < 2) {
                this.disconnect(document);
            } else {
                this.file = root.getFile((IPath)filePath);
                this.project = this.file.getProject();
            }
        }
    }

    public void createAndAddEmptyMessage(ITextRegion valueRegion, IDOMNode parentNode, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, String problemId, ValidationProblemAttribute ... problemAttributes) {
        this.createAndAddMessage(valueRegion, parentNode, messageText, reporter, quickfixFactory, false, false, 7, problemId, problemAttributes);
    }

    private void createAndAddMessage(int offset, int length, int emptyMsgOffset, int emptyMsgLength, boolean missingEndQuote, IDOMNode beanNode, String text, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, boolean showErrorMessage, int severity, String problemId, ValidationProblemAttribute ... problemAttributes) {
        BeanQuickAssistProcessor processor;
        if (beanNode == null || text == null || messageText == null || this.document == null) {
            return;
        }
        if (showErrorMessage) {
            LocalizedMessage message = new LocalizedMessage(severity, messageText);
            message.setOffset(offset);
            message.setLength(length);
            try {
                message.setLineNo(this.document.getLineOfOffset(offset) + 1);
            }
            catch (BadLocationException badLocationException) {
                message.setLineNo(-1);
            }
            reporter.addMessage((IValidator)this, (IMessage)message);
        }
        LocalizedMessage messageEmpty = new LocalizedMessage(7, messageText);
        messageEmpty.setOffset(emptyMsgOffset);
        messageEmpty.setLength(emptyMsgLength);
        try {
            messageEmpty.setLineNo(this.document.getLineOfOffset(offset) + 1);
        }
        catch (BadLocationException badLocationException) {
            messageEmpty.setLineNo(-1);
        }
        if (reporter instanceof IncrementalReporter && (processor = quickfixFactory.create(offset, length, text, missingEndQuote, beanNode, this, problemId, problemAttributes)) != null) {
            AnnotationInfo[] existingInfos;
            messageEmpty.setAttribute(IQuickAssistProcessor.class.getName(), processor);
            QuickfixAnnotationInfo info = new QuickfixAnnotationInfo((IMessage)messageEmpty);
            IncrementalReporter incrementalReporter = (IncrementalReporter)reporter;
            AnnotationInfo[] annotationInfoArray = existingInfos = incrementalReporter.getAnnotationInfo();
            int n = existingInfos.length;
            int n2 = 0;
            while (n2 < n) {
                Object existingProcessor;
                AnnotationInfo existingInfo = annotationInfoArray[n2];
                IMessage existingMessage = existingInfo.getMessage();
                if (existingMessage.getOffset() == messageEmpty.getOffset() && existingMessage.getText().equals(messageEmpty.getText()) && (existingProcessor = existingMessage.getAttribute(IQuickAssistProcessor.class.getName())) != null && existingProcessor.equals(processor)) {
                    return;
                }
                ++n2;
            }
            incrementalReporter.addAnnotationInfo((IValidator)this, (AnnotationInfo)info);
        }
    }

    public void createAndAddMessage(ITextRegion valueRegion, IDOMNode parentNode, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, boolean affectsWholeBean, boolean showError, int severity, String problemId, ValidationProblemAttribute ... problemAttributes) {
        int msgLength;
        int msgOffset;
        int offset = valueRegion.getStart() + parentNode.getStartOffset();
        boolean missingEndQuote = false;
        if (this.document == null) {
            return;
        }
        String text = this.document.get().substring(offset, offset + valueRegion.getLength());
        text = text.trim();
        int length = text.length();
        if (text.startsWith("'") || text.startsWith("\"")) {
            ++offset;
            --length;
            text = text.substring(1);
        }
        if (text.endsWith("'") || text.endsWith("\"")) {
            --length;
            text = text.substring(0, text.length() - 1);
        } else {
            missingEndQuote = true;
        }
        if (affectsWholeBean) {
            msgOffset = parentNode.getStartOffset();
            msgLength = parentNode.getEndOffset() - msgOffset;
            offset = msgOffset;
            length = msgLength;
        } else {
            msgOffset = offset;
            msgLength = length;
        }
        this.createAndAddMessage(offset, length, msgOffset, msgLength + 1, missingEndQuote, parentNode, text, messageText, reporter, quickfixFactory, showError, severity, problemId, problemAttributes);
    }

    public void createAndAddMessage(ITextRegion valueRegion, IDOMNode parentNode, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, boolean affectsWholeBean, int severity, String problemId, ValidationProblemAttribute ... problemAttributes) {
        this.createAndAddMessage(valueRegion, parentNode, messageText, reporter, quickfixFactory, affectsWholeBean, true, severity, problemId, problemAttributes);
    }

    public void createAndAddMessage(ITextRegion valueRegion, IDOMNode parentNode, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, int severity, String problemId, ValidationProblemAttribute ... problemAttributes) {
        this.createAndAddMessage(valueRegion, parentNode, messageText, reporter, quickfixFactory, false, true, severity, problemId, problemAttributes);
    }

    public void createAndAddMessageForNode(IDOMNode node, IDOMNode beanNode, String text, String messageText, IReporter reporter, QuickfixProcessorFactory quickfixFactory, int severity, String problemId, ValidationProblemAttribute ... problemAttributes) {
        int offset = node.getStartOffset();
        int length = node.getEndOffset() - offset;
        boolean missingEndQuote = false;
        this.createAndAddMessage(offset, length, offset, length + 1, missingEndQuote, beanNode, text, messageText, reporter, quickfixFactory, true, severity, problemId, problemAttributes);
    }

    public void disconnect(IDocument document) {
        if (this.model != null) {
            this.model.releaseFromRead();
            this.model = null;
        }
        this.document = null;
    }

    private final Set<IResourceModelElement> getContextElements(IBeansConfig config) {
        LinkedHashSet<IResourceModelElement> contextElements = new LinkedHashSet<IResourceModelElement>();
        BeansCorePlugin.getModel().accept((IModelElementVisitor)new ContextElementVisitor(config.getElementResource(), contextElements), (IProgressMonitor)new NullProgressMonitor());
        if (contextElements.isEmpty()) {
            contextElements.add((IResourceModelElement)config);
        }
        return contextElements;
    }

    public IFile getFile() {
        return this.file;
    }

    private IDOMNode getNodeAt(int documentOffset, int length) {
        IndexedRegion node = null;
        if (this.model != null) {
            node = this.model.getIndexedRegion(documentOffset);
            if (node == null) {
                return null;
            }
            if (node.getStartOffset() < documentOffset || node.getStartOffset() >= documentOffset + length) {
                node = null;
            }
        }
        if (node instanceof IDOMNode && !(node instanceof TextImpl)) {
            return this.getNonTextNode((IDOMNode)node);
        }
        return null;
    }

    private IDOMNode getNonTextNode(IDOMNode node) {
        if (node == null || !(node instanceof IDOMText)) {
            return node;
        }
        return this.getNonTextNode((IDOMNode)node.getParentNode());
    }

    public IProject getProject() {
        return this.project;
    }

    public void validate(IRegion dirtyRegion, IValidationContext context, IReporter reporter) {
        if (this.document == null || !BeansCoreUtils.isBeansConfig((IResource)this.file)) {
            return;
        }
        if (!(this.document instanceof IStructuredDocument)) {
            return;
        }
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.document).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        HashSet<IDOMNode> checkedNodes = new HashSet<IDOMNode>();
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion region = iStructuredDocumentRegionArray[n2];
            IDOMNode node = this.getNodeAt(region.getStartOffset(), region.getLength());
            if (node != null && !checkedNodes.contains(node)) {
                this.validateNode(node, reporter);
                this.addCheckedNodes(node, checkedNodes);
            }
            ++n2;
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    private void validateNode(IDOMNode node, IReporter reporter) {
        IBeansModel model = BeansCorePlugin.getModel();
        Set configs = model.getConfigs(this.file, true);
        for (IBeansConfig config : configs) {
            Set<IResourceModelElement> contextElements = this.getContextElements(config);
            for (IResourceModelElement contextElement : contextElements) {
                BeanValidatorVisitor visitor = new BeanValidatorVisitor(config, contextElement, reporter, this);
                if (!visitor.visitNode(node, true, true)) continue;
                return;
            }
        }
    }

    private static class ContextElementVisitor
    implements IModelElementVisitor {
        private final Set<IResourceModelElement> contextElements;
        private final IResource resource;
        private IBeansConfig currentConfig = null;

        public ContextElementVisitor(IResource resource, Set<IResourceModelElement> contextElements) {
            this.resource = resource;
            this.contextElements = contextElements;
        }

        public boolean visit(IModelElement element, IProgressMonitor monitor) {
            if (element instanceof IBeansModel) {
                return true;
            }
            if (element instanceof IBeansProject) {
                return true;
            }
            if (element instanceof IImportedBeansConfig) {
                if (this.resource.equals((Object)((IImportedBeansConfig)element).getElementResource())) {
                    this.contextElements.add((IResourceModelElement)this.currentConfig);
                }
                return true;
            }
            if (element instanceof IBeansConfig) {
                this.currentConfig = (IBeansConfig)element;
                return true;
            }
            if (element instanceof IBeansImport) {
                for (IImportedBeansConfig config : ((IBeansImport)element).getImportedBeansConfigs()) {
                    config.accept((IModelElementVisitor)this, monitor);
                }
                return false;
            }
            if (element instanceof IBeansConfigSet) {
                for (IBeansConfig config : ((IBeansConfigSet)element).getConfigs()) {
                    if (!this.resource.equals((Object)config.getElementResource())) continue;
                    this.contextElements.add((IResourceModelElement)((IBeansConfigSet)element));
                    break;
                }
                return false;
            }
            return false;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this._message = null;
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalizedMessage) {
                LocalizedMessage m = (LocalizedMessage)((Object)obj);
                return m.getText().equals(this.getText()) && m.getOffset() == this.getOffset();
            }
            return false;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public int hashCode() {
            return (String.valueOf(this.getText()) + this.getOffset()).hashCode();
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }
    }
}

