/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.ui.commons;

import com.atlassian.connector.eclipse.ui.commons.AtlassianUiUtil;
import com.atlassian.connector.eclipse.ui.commons.IEditorResource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorResourceAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTERS = new Class[]{IEditorResource.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IAdaptable adaptable;
        IResource resource;
        if (!IEditorResource.class.equals((Object)adapterType)) {
            return null;
        }
        if (adaptableObject instanceof IResource) {
            return new BasicEditorResource((IResource)adaptableObject);
        }
        if (adaptableObject instanceof IEditorInput) {
            IEditorInput editorInput = (IEditorInput)adaptableObject;
            IResource resource2 = (IResource)editorInput.getAdapter(IResource.class);
            if (resource2 == null) {
                return null;
            }
            IEditorPart editorPart = this.getActiveEditor();
            LineRange lineRange = AtlassianUiUtil.getSelectedLineNumberRangeFromEditorInput(editorPart, editorInput);
            return new BasicEditorResource(resource2, lineRange);
        }
        if (adaptableObject instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)adaptableObject).getAdapter(IResource.class)) != null) {
            return new BasicEditorResource(resource);
        }
        return null;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchWindow window = null;
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (window != null && window.getActivePage() != null) {
            return window.getActivePage().getActiveEditor();
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTERS;
    }

    private final class BasicEditorResource
    implements IEditorResource {
        private final IResource resource;
        private final LineRange lineRange;

        public BasicEditorResource(IResource resource, LineRange lineRange) {
            this.resource = resource;
            this.lineRange = lineRange;
        }

        private BasicEditorResource(IResource resource) {
            this(resource, (LineRange)null);
        }

        public LineRange getLineRange() {
            return this.lineRange;
        }

        public IResource getResource() {
            return this.resource;
        }

        public Object getAdapter(Class adapter) {
            if (!IResource.class.equals((Object)adapter)) {
                return null;
            }
            return this.resource;
        }
    }
}

