/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.util.AbstractCellPainterBuilder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class UniqueItemsAsShapeBuilder
extends AbstractCellPainterBuilder {
    private final int width;
    private final int height;
    private final int hAlignment;
    private final Map<Object, ShapeDescriptor> shapesByItem;

    public UniqueItemsAsShapeBuilder(int theWidth, int theHeight, int horizAlignment, Map<Object, ShapeDescriptor> theShapesByItem) {
        this.width = theWidth;
        this.height = theHeight;
        this.hAlignment = horizAlignment;
        this.shapesByItem = theShapesByItem;
    }

    private List<ShapeDescriptor> getterShapesIn(TreeItem tItem, RuleFieldAccessor getter) {
        Set<Comparable<?>> values = RuleUtil.uniqueItemsIn(tItem.getData(), getter);
        ArrayList<ShapeDescriptor> shapes = new ArrayList<ShapeDescriptor>(values.size());
        Iterator<Comparable<?>> iter = values.iterator();
        while (iter.hasNext()) {
            ShapeDescriptor desc = this.shapesByItem.get(iter.next());
            if (desc == null) continue;
            shapes.add(desc);
        }
        return shapes;
    }

    @Override
    public void addPainterFor(final Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> listenersByEventCode) {
        Listener paintListener = new Listener(){
            final int gap = 2;

            public void handleEvent(Event event) {
                if (event.index != columnIndex) {
                    return;
                }
                List shapes = UniqueItemsAsShapeBuilder.this.getterShapesIn((TreeItem)event.item, getter);
                if (shapes.isEmpty()) {
                    return;
                }
                GC gc = event.gc;
                int verticalOffset = event.height / 2 - UniqueItemsAsShapeBuilder.this.height / 2;
                Color original = gc.getBackground();
                int cellWidth = UniqueItemsAsShapeBuilder.this.widthOf(columnIndex, tree);
                int i = 0;
                while (i < shapes.size()) {
                    ShapeDescriptor shape = (ShapeDescriptor)shapes.get(i);
                    Color clr = UniqueItemsAsShapeBuilder.colorManager().colourFor(shape.rgbColor);
                    gc.setBackground(clr);
                    int xOffset = 0;
                    int step = (UniqueItemsAsShapeBuilder.this.width + 2) * i;
                    switch (UniqueItemsAsShapeBuilder.this.hAlignment) {
                        case 0x1000000: {
                            xOffset = cellWidth / 2 - UniqueItemsAsShapeBuilder.this.width / 2 - 3 + step;
                            break;
                        }
                        case 131072: {
                            xOffset = cellWidth - UniqueItemsAsShapeBuilder.this.width - 3;
                            break;
                        }
                        case 16384: {
                            xOffset = 3 + step;
                        }
                    }
                    ShapePainter.drawShape(UniqueItemsAsShapeBuilder.this.width, UniqueItemsAsShapeBuilder.this.height, shape.shape, gc, event.x + xOffset, event.y + verticalOffset, null);
                    ++i;
                }
                gc.setBackground(original);
            }
        };
        Listener measureListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != columnIndex) {
                    return;
                }
                Object item = ((TreeItem)event.item).getData();
                if (item == null) {
                    return;
                }
                Set<Comparable<?>> items = RuleUtil.uniqueItemsIn(item, getter);
                event.width = UniqueItemsAsShapeBuilder.this.width + items.size() * UniqueItemsAsShapeBuilder.this.width;
                event.height = UniqueItemsAsShapeBuilder.this.height;
            }
        };
        UniqueItemsAsShapeBuilder.addListener((Control)tree, 42, paintListener, listenersByEventCode);
        UniqueItemsAsShapeBuilder.addListener((Control)tree, 41, measureListener, listenersByEventCode);
    }
}

