/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd;

import java.util.StringTokenizer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.ui.views.cpd.CPDView;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CPDViewTooltipListener
implements Listener {
    private final CPDView view;
    private Listener labelListener;
    private Shell tip;
    private TreeItem shownItem;

    public CPDViewTooltipListener(CPDView view) {
        this.view = view;
    }

    public void initialize() {
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                Tree tree = CPDViewTooltipListener.this.view.getTreeViewer().getTree();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TREEITEM");
                        tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        tree.notifyListeners(13, e);
                        shell.dispose();
                        CPDViewTooltipListener.this.view.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
    }

    public void handleEvent(Event event) {
        Tree tree = this.view.getTreeViewer().getTree();
        TreeItem item = tree.getItem(new Point(event.x, event.y));
        switch (event.type) {
            case 1: 
            case 12: {
                this.disposeTooltip();
                break;
            }
            case 5: {
                if (this.shownItem == null || this.shownItem.equals(item)) break;
                this.disposeTooltip();
                break;
            }
            case 32: {
                TreeNode node;
                if (item == null || !((node = (TreeNode)item.getData()).getValue() instanceof Match)) break;
                Match match = (Match)node.getValue();
                String text = this.createText(match);
                this.showTooltip(item, text);
                break;
            }
        }
    }

    private String createText(Match match) {
        String text = match.getSourceCodeSlice().replaceAll("\t", "    ");
        StringBuilder outputString = new StringBuilder();
        StringTokenizer lines = new StringTokenizer(text, "\n");
        int i = 0;
        while (lines.hasMoreTokens()) {
            if (i >= 6) {
                outputString.append("\n...\n");
                break;
            }
            outputString.append(lines.nextToken()).append('\n');
            ++i;
        }
        return outputString.toString();
    }

    private void disposeTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
    }

    private void showTooltip(TreeItem item, String text) {
        Tree tree = this.view.getTreeViewer().getTree();
        Display display = tree.getDisplay();
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = new Shell(540676);
        this.tip.setBackground(display.getSystemColor(29));
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.tip.setLayout((Layout)layout);
        Label label = new Label((Composite)this.tip, 0);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setData("_TREEITEM", (Object)item);
        label.setText(text);
        label.addListener(7, this.labelListener);
        label.addListener(3, this.labelListener);
        Point size = this.tip.computeSize(-1, -1);
        Rectangle rect = item.getBounds(2);
        Point pt = tree.toDisplay(rect.x, rect.y);
        Rectangle treeSize = tree.getClientArea();
        Point treePt = tree.toDisplay(treeSize.width, treeSize.height);
        if (pt.x + size.x + 50 > treePt.x) {
            size.x = treePt.x - pt.x - 50;
        }
        if (pt.y + size.y + 3 > treePt.y) {
            size.y = treePt.y - pt.y - 3;
        }
        this.tip.setBounds(pt.x + 50, pt.y + 3, size.x, size.y);
        this.tip.setVisible(true);
        this.shownItem = item;
    }
}

