/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTUtil {
    private static PMDPlugin plugin = PMDPlugin.getDefault();
    private static final String TOOLTIP_SUFFIX = ".tooltip";

    private SWTUtil() {
    }

    public static void logInfo(String message) {
        plugin.logInformation(message);
    }

    public static void logError(String message, Throwable error) {
        plugin.logError(message, error);
    }

    public static void asRadioButtons(final Collection<Button> buttons) {
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                for (Button button : buttons) {
                    if (e.widget == button) continue;
                    button.setSelection(false);
                }
                ((Button)e.widget).setSelection(true);
            }
        };
        for (Button button : buttons) {
            button.addListener(13, listener);
        }
    }

    public static Set<String> asStringSet(String input, char separator) {
        List<String> values = Arrays.asList(input.split("" + separator));
        return new HashSet<String>(values);
    }

    public static String asString(Collection<String> values, char separator) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        String[] strings = values.toArray(new String[values.size()]);
        StringBuilder sb = new StringBuilder(strings[0]);
        int i = 1;
        while (i < strings.length) {
            sb.append(separator).append(strings[i]);
            ++i;
        }
        return sb.toString();
    }

    public static void setEnabled(Control control, boolean flag) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(flag);
    }

    public static void setEnabled(Control[] controls, boolean state) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            SWTUtil.setEnabled(control, state);
            ++n2;
        }
    }

    public static void setEnabled(Collection<Control> controls, boolean flag) {
        for (Control control : controls) {
            SWTUtil.setEnabled(control, flag);
        }
    }

    public static void setEnabledRecursive(Control[] controls, boolean state) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                SWTUtil.setEnabledRecursive(((Composite)control).getChildren(), state);
            }
            SWTUtil.setEnabled(control, state);
            ++n2;
        }
    }

    public static String stringFor(String key) {
        return plugin.getStringTable().getString(key);
    }

    public static String tooltipFor(String key) {
        String tooltip;
        String ttKey = String.valueOf(key) + TOOLTIP_SUFFIX;
        return ttKey.equals(tooltip = SWTUtil.stringFor(ttKey)) ? SWTUtil.stringFor(key) : tooltip;
    }

    public static void releaseListeners(Control control, int listenerType) {
        Listener[] listeners;
        Listener[] listenerArray = listeners = control.getListeners(listenerType);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            control.removeListener(listenerType, listener);
            ++n2;
        }
    }

    public static String[] labelsIn(Object[][] items, int columnIndex) {
        String[] labels = new String[items.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = items[i][columnIndex].toString();
            ++i;
        }
        return labels;
    }

    public static void deselectAll(Combo combo) {
        int count = combo.getItems().length;
        int i = 0;
        while (i < count) {
            combo.deselect(i);
            ++i;
        }
    }

    public static String[] i18lLabelsIn(Object[][] items, int columnIndex) {
        String[] labels = SWTUtil.labelsIn(items, columnIndex);
        String xlation = null;
        int i = 0;
        while (i < labels.length) {
            xlation = SWTUtil.stringFor(labels[i]);
            labels[i] = xlation == null ? labels[i] : xlation;
            ++i;
        }
        return labels;
    }
}

