/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.NumericPropertyDescriptor;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractMultiValueEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.IntegerEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.IntegerMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.NumericConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class MultiIntegerEditorFactory
extends AbstractMultiValueEditorFactory {
    public static final MultiIntegerEditorFactory instance = new MultiIntegerEditorFactory();
    private static final Integer[] emptyIntSet = new Integer[0];

    private MultiIntegerEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new IntegerMultiProperty(name, "Integer values " + name, NumericConstants.ZERO, Integer.valueOf(10), new Integer[]{NumericConstants.ZERO}, 0.0f);
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return this.currentIntegers((Text)valueControl);
    }

    private Integer[] currentIntegers(Text textWidget) {
        String[] numberStrings = this.textWidgetValues(textWidget);
        if (numberStrings.length == 0) {
            return emptyIntSet;
        }
        ArrayList<Integer> ints = new ArrayList<Integer>(numberStrings.length);
        Integer intrg = null;
        String[] stringArray = numberStrings;
        int n = numberStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String numString = stringArray[n2];
            try {
                intrg = Integer.parseInt(numString);
            }
            catch (Exception exception) {}
            if (intrg != null) {
                ints.add(intrg);
            }
            ++n2;
        }
        return ints.toArray(new Integer[ints.size()]);
    }

    private static NumericPropertyDescriptor<?> numericPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (NumericPropertyDescriptor)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (NumericPropertyDescriptor)desc;
    }

    @Override
    protected Control addWidget(Composite parent, Object value, PropertyDescriptor<?> desc, PropertySource source) {
        NumericPropertyDescriptor<?> ip = MultiIntegerEditorFactory.numericPropertyFrom(desc);
        return IntegerEditorFactory.newSpinner(parent, ip, value);
    }

    @Override
    protected void setValue(Control widget, Object valueIn) {
        Spinner spinner = (Spinner)widget;
        int value = valueIn == null ? spinner.getMinimum() : ((Number)valueIn).intValue();
        spinner.setSelection(value);
    }

    @Override
    protected void configure(final Text textWidget, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener) {
        final IntegerMultiProperty imp = (IntegerMultiProperty)MultiIntegerEditorFactory.numericPropertyFrom(desc);
        textWidget.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                Object[] newValue = MultiIntegerEditorFactory.this.currentIntegers(textWidget);
                Object[] existingValue = (Integer[])MultiIntegerEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)imp);
                if (CollectionUtil.areSemanticEquals((Object[])existingValue, (Object[])newValue)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)imp, (Object)newValue);
                MultiIntegerEditorFactory.this.fillWidget(textWidget, desc, source);
                listener.changed(source, desc, (Object)newValue);
            }
        });
    }

    @Override
    protected void update(PropertySource source, PropertyDescriptor<?> desc, List<Object> newValues) {
        source.setProperty((PropertyDescriptor)((IntegerMultiProperty)desc), (Object)newValues.toArray(new Integer[newValues.size()]));
    }

    @Override
    protected Object addValueIn(Control widget, PropertyDescriptor<?> desc, PropertySource source) {
        Integer[] newValues;
        Integer newValue = ((Spinner)widget).getSelection();
        Object[] currentValues = (Integer[])this.valueFor(source, desc);
        if (currentValues.length == (newValues = (Integer[])CollectionUtil.addWithoutDuplicates((Object[])currentValues, (Object)newValue)).length) {
            return null;
        }
        source.setProperty((PropertyDescriptor)((IntegerMultiProperty)desc), (Object)newValues);
        return newValue;
    }
}

