/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.operations;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RunBuildJob
extends Job {
    private final BambooBuild build;
    private final TaskRepository repository;

    public RunBuildJob(BambooBuild build, TaskRepository repository) {
        super("Run build");
        this.build = build;
        this.repository = repository;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BambooClient client = BambooCorePlugin.getRepositoryConnector().getClientManager().getClient(this.repository);
        try {
            client.runBuild(monitor, this.repository, this.build);
        }
        catch (CoreException e) {
            Status status = new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Failed to run build " + this.build.getPlanKey(), (Throwable)e);
            StatusHandler.log((IStatus)status);
            return status;
        }
        return Status.OK_STATUS;
    }
}

