/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImageUtil;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooUiUtil;
import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class BuildLabelProvider
implements ILabelProvider,
IFontProvider {
    public Image getImage(Object element) {
        if (element instanceof EclipseBambooBuild) {
            return BambooImageUtil.getImage(((EclipseBambooBuild)element).getBuild());
        }
        return CommonImages.getImage((ImageDescriptor)BambooImages.STATUS_DISABLED);
    }

    public String getText(Object element) {
        StringBuilder builder = new StringBuilder();
        EclipseBambooBuild bambooBuild = (EclipseBambooBuild)element;
        if (bambooBuild.getBuild().getPlanName() == null) {
            builder.append("N/A");
        } else {
            builder.append(bambooBuild.getBuild().getPlanName());
        }
        if (bambooBuild.getBuild().getPlanKey() != null) {
            block5: {
                builder.append("  [");
                builder.append(bambooBuild.getBuild().getPlanKey());
                try {
                    String number = String.valueOf(bambooBuild.getBuild().getNumber());
                    builder.append("-");
                    builder.append(number);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (bambooBuild.getBuild().getPlanName() == null) break block5;
                    builder.append("-");
                    builder.append("N/A");
                }
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public Font getFont(Object element) {
        return BambooUiUtil.getFontForBuildStatus(element);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

