/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.parts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.graph.figures.BeanFigure;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeanPart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    public Bean getBean() {
        return (Bean)((Object)this.getModel());
    }

    protected IFigure createFigure() {
        Bean bean = this.getBean();
        BeanFigure figure = new BeanFigure(bean);
        return figure;
    }

    protected void createEditPolicies() {
    }

    protected void refreshVisuals() {
        Dimension dim = this.getFigure().getPreferredSize();
        Rectangle rect = null;
        rect = this.getBean().getInnerBeans().length > 0 ? new Rectangle(this.getBean().x, this.getBean().y, dim.width + 3, dim.height) : new Rectangle(this.getBean().x, this.getBean().y, dim.width + 3, dim.height);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rect);
        this.getFigure().setBounds(rect);
    }

    protected List getModelSourceConnections() {
        return this.getBean().outgoing;
    }

    protected List getModelTargetConnections() {
        return this.getBean().incoming;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart conn) {
        return new TopOrBottomAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new TopOrBottomAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart conn) {
        return new TopOrBottomAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new TopOrBottomAnchor(this.getFigure());
    }

    public void setSelected(int value) {
        super.setSelected(value);
        Border border = this.getFigure().getBorder();
        if (border instanceof LineBorder) {
            if (value != 0) {
                ((LineBorder)border).setWidth(2);
            } else {
                ((LineBorder)border).setWidth(1);
            }
            this.getFigure().repaint();
        }
    }

    public void performRequest(Request req) {
        if (req.getType() == "open") {
            if (BeansUIUtils.shouldOpenConfigFile()) {
                BeansUIUtils.openInEditor((IResourceModelElement)this.getBean().getBean());
            } else {
                IType type = BeansModelUtils.getBeanType((IBean)this.getBean().getBean(), null);
                if (type != null) {
                    SpringUIUtils.openInEditor((IJavaElement)type);
                }
            }
        }
        super.performRequest(req);
    }

    protected static class TopOrBottomAnchor
    extends ChopboxAnchor {
        public TopOrBottomAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getOwner().getBounds().getCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            p = reference.y < p.y ? this.getOwner().getBounds().getTop() : this.getOwner().getBounds().getBottom();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

