/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInputFactory;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.util.ObjectUtils;

public class GraphEditorInput
implements IEditorInput,
IPersistableElement {
    private String elementId;
    private String contextId;
    private String name = "Spring Dependency Graph";
    private String toolTip = " ";
    private boolean hasError;

    public GraphEditorInput(String elementId) {
        this(elementId, GraphEditorInput.getContext(elementId));
    }

    public GraphEditorInput(String elementId, String contextId) {
        this.elementId = elementId;
        this.contextId = contextId;
    }

    protected void init() {
        IModelElement element = BeansCorePlugin.getModel().getElement(this.elementId);
        IModelElement context = BeansCorePlugin.getModel().getElement(this.contextId);
        if (element instanceof IBeansConfig) {
            String toolTipPrefix = BeansGraphPlugin.getResourceString("ShowGraphAction.name.config");
            IBeansConfig config = (IBeansConfig)element;
            IResource resource = config.getElementResource();
            if (resource != null) {
                if (config.isElementArchived()) {
                    ZipEntryStorage storage = new ZipEntryStorage((IResourceModelElement)config);
                    this.name = storage.getName();
                    this.toolTip = String.valueOf(toolTipPrefix) + storage.getFile().getProjectRelativePath().toString() + " - " + storage.getFullPath().toString();
                } else {
                    this.name = resource.getName();
                    this.toolTip = String.valueOf(toolTipPrefix) + resource.getFullPath().toString();
                }
            } else {
                this.name = BeansGraphPlugin.getResourceString("ShowGraphAction.name.undefined");
                this.toolTip = String.valueOf(BeansGraphPlugin.getResourceString("ShowGraphAction.name.config")) + this.name;
            }
        } else if (element instanceof IBeansConfigSet) {
            IModelElement parent = ((IBeansConfigSet)element).getElementParent();
            this.name = element.getElementName();
            this.toolTip = String.valueOf(BeansGraphPlugin.getResourceString("ShowGraphAction.name.configSet")) + parent.getElementName() + '/' + element.getElementName();
        } else if (element instanceof IBeansComponent || element instanceof IBean) {
            this.name = element.getElementName();
            StringBuffer buffer = new StringBuffer();
            if (element instanceof IBeansComponent) {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.component"));
            } else {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.bean"));
            }
            if (context instanceof IBeansConfig) {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.config"));
                buffer.append(context.getElementName());
                buffer.append(": ");
            } else if (context instanceof IBeansConfigSet) {
                buffer.append(BeansGraphPlugin.getResourceString("ShowGraphAction.name.configSet"));
                buffer.append(context.getElementParent().getElementName());
                buffer.append('/');
                buffer.append(context.getElementName());
                buffer.append(": ");
            }
            buffer.append(element.getElementName());
            this.toolTip = buffer.toString();
        }
    }

    private IModelElement getElement(String elementId) {
        return BeansCorePlugin.getModel().getElement(elementId);
    }

    public String getName() {
        return this.name;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IModelElement.class) {
            return this.getElement(this.elementId);
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return BeansUIImages.DESC_OBJS_SPRING;
    }

    public IPersistableElement getPersistable() {
        return this.hasError ? null : this;
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public String getFactoryId() {
        return GraphEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        GraphEditorInputFactory.saveState(memento, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphEditorInput)) {
            return false;
        }
        GraphEditorInput that = (GraphEditorInput)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.elementId, (Object)that.elementId)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.contextId, (Object)that.contextId);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.elementId);
        return 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.contextId);
    }

    private static IModelElement getContext(IModelElement element) {
        if (element instanceof IBean) {
            return element.getElementParent();
        }
        if (element instanceof IBeanConstructorArgument || element instanceof IBeanProperty) {
            return element.getElementParent().getElementParent();
        }
        return element;
    }

    private static String getContext(String elementId) {
        IModelElement element = BeansCorePlugin.getModel().getElement(elementId);
        return GraphEditorInput.getContext(element).getElementID();
    }
}

