/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.actions.ExportAction;
import org.springframework.ide.eclipse.beans.ui.graph.actions.GraphContextMenuProvider;
import org.springframework.ide.eclipse.beans.ui.graph.actions.OpenConfigFile;
import org.springframework.ide.eclipse.beans.ui.graph.actions.OpenJavaType;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphOutlinePage;
import org.springframework.ide.eclipse.beans.ui.graph.model.Graph;
import org.springframework.ide.eclipse.beans.ui.graph.parts.GraphicalPartFactory;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

public class GraphEditor
extends EditorPart
implements ISelectionListener {
    public static final String EDITOR_ID = "org.springframework.ide.eclipse.beans.ui.graph.editor";
    public static final String CONTEXT_MENU_ID = "org.springframework.ide.eclipse.beans.ui.graph.editor.contextmenu";
    private GraphOutlinePage outlinePage;
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private SelectionSynchronizer synchronizer;
    private List selectionActions = new ArrayList();
    private List propertyActions = new ArrayList();
    private IModelChangeListener modelChangeListener = new GraphEditorInputModelChangeListener();
    private Preferences.IPropertyChangeListener propertyChangeListener = new GraphEditorPropertyChangeListener();
    private volatile boolean isUpdating = false;

    public GraphEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getToolTipText());
    }

    protected void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    protected synchronized void initializeGraphicalViewer() {
        if (!this.isUpdating) {
            Job job = new Job("Initialize Beans Graph '" + this.getPartName() + "'"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (GraphEditor.this.getEditorInput() instanceof GraphEditorInput && GraphEditor.this.getGraphicalViewer() != null && GraphEditor.this.getGraphicalViewer().getControl() != null) {
                            if (!BeansCorePlugin.getModel().isInitialized()) {
                                this.schedule(2500L);
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            final GraphEditorInput input = (GraphEditorInput)GraphEditor.this.getEditorInput();
                            input.init();
                            final Graph graph = new Graph(input);
                            graph.init();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (GraphEditor.this.getGraphicalViewer() != null && GraphEditor.this.getGraphicalViewer().getControl() != null) {
                                        GraphEditor.this.setPartName(input.getName());
                                        GraphEditor.this.setContentDescription(input.getToolTipText());
                                        graph.layout(GraphEditor.this.getGraphicalViewer().getControl().getFont());
                                        GraphEditor.this.getGraphicalViewer().setContents((Object)graph);
                                    }
                                }
                            });
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        GraphEditor.this.isUpdating = false;
                    }
                }
            };
            job.setRule((ISchedulingRule)new BlockingOnSelfSchedulingRule());
            job.setPriority(10);
            this.isUpdating = true;
            job.schedule();
        }
    }

    protected void configureGraphicalViewer() {
        ScalableRootEditPart root = new ScalableRootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getActionRegistry().registerAction((IAction)new ExportAction(this));
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        viewer.getControl().setBackground(ColorConstants.listBackground);
        GraphContextMenuProvider provider = new GraphContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(CONTEXT_MENU_ID, (MenuManager)provider, (ISelectionProvider)viewer);
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == ZoomManager.class) {
            return this.getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected IPropertySheetPage getPropertySheetPage() {
        PropertySheetPage page = new PropertySheetPage();
        page.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(this.getCommandStack()));
        return page;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected GraphOutlinePage getOutlinePage() {
        RootEditPart rootEditPart;
        if (this.outlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableRootEditPart) {
            this.outlinePage = new GraphOutlinePage((ScalableRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new ExportAction(this);
        registry.registerAction((IAction)action);
        action = new OpenJavaType((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new OpenConfigFile((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new PrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void createPartControl(Composite parent) {
        this.createGraphicalViewer(parent);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        BeansCorePlugin.getModel().removeChangeListener(this.modelChangeListener);
        BeansUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected List getPropertyActions() {
        return this.propertyActions;
    }

    protected List getSelectionActions() {
        return this.selectionActions;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
        BeansCorePlugin.getModel().addChangeListener(this.modelChangeListener);
        BeansUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    protected void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void setEditDomain(DefaultEditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.graphicalViewer = viewer;
        this.getEditDomain().addViewer((EditPartViewer)viewer);
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction(iter.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        dialog.setOriginalName("graph.jpg");
        dialog.create();
        dialog.setMessage(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.message"));
        dialog.setOriginalName("graph.png");
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            String ext = file.getFileExtension();
            if (ext == null || ext.length() == 0 || !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("bmp") && !ext.equalsIgnoreCase("png")) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), null, (IStatus)BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.error")));
            } else if (ext.equalsIgnoreCase("PNG") && !SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)3)) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Problem", (String)"Exporting to PNG format is only supported on Eclipse 3.3 or newer", (IStatus)BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.error")));
            } else if ("PNG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 5);
            } else if ("JPG".equalsIgnoreCase(ext) || "JPEG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 4);
            } else if ("BMP".equalsIgnoreCase(ext)) {
                this.saveImage(file, 0);
            }
        }
    }

    public void saveImage(final IFile file, final int format) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(GraphEditor.this.createImage(format)), true, false, monitor);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(GraphEditor.this.createImage(format)), true, monitor);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)GraphEditor.this.getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.text"), (IStatus)e.getStatus());
                }
            }
        };
        try {
            Shell shell = this.getSite().getWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            BeansGraphPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public byte[] createImage(int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Display device = this.getGraphicalViewer().getControl().getDisplay();
        LayerManager lm = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getClientArea();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            image = new Image((Device)device, r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private class BlockingOnSelfSchedulingRule
    implements ISchedulingRule {
        private BlockingOnSelfSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof BlockingOnSelfSchedulingRule;
        }
    }

    private class GraphEditorInputModelChangeListener
    implements IModelChangeListener {
        private GraphEditorInputModelChangeListener() {
        }

        public void elementChanged(ModelChangeEvent event) {
            Display display;
            final GraphEditorInput beansInput = (GraphEditorInput)GraphEditor.this.getEditorInput();
            boolean refresh = false;
            IModelElement changedElement = event.getElement();
            IModelElement originalInputElement = BeansCorePlugin.getModel().getElement(beansInput.getElementId());
            IModelElement originalContextElement = BeansCorePlugin.getModel().getElement(beansInput.getContextId());
            if (changedElement instanceof IBeansConfig) {
                IResource changedResource = ((IBeansConfig)changedElement).getElementResource();
                refresh = this.checkForRefresh(changedResource, originalInputElement) || this.checkForRefresh(changedResource, originalContextElement);
            } else if (changedElement instanceof IBeansProject) {
                IBeansProject beansProject = (IBeansProject)changedElement;
                boolean bl = refresh = BeansModelUtils.getChildForElement((IModelElement)beansProject, (IModelElement)originalInputElement) != null || BeansModelUtils.getChildForElement((IModelElement)beansProject, (IModelElement)originalContextElement) != null;
            }
            if (!refresh && event.getType() == ModelChangeEvent.Type.REMOVED && originalInputElement == null) {
                display = GraphEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphEditor.this.closeEditor();
                    }
                });
            }
            if (refresh) {
                display = GraphEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphEditor.this.setInput(beansInput);
                        GraphEditor.this.initializeGraphicalViewer();
                    }
                });
            }
        }

        private boolean checkForRefresh(IResource changedResource, IModelElement originalInputElement) {
            boolean refresh = false;
            if (originalInputElement instanceof IBean) {
                IResource originalResource = ((IBean)originalInputElement).getElementResource();
                refresh = originalResource.equals((Object)changedResource);
            } else if (originalInputElement instanceof IBeansConfig) {
                IResource originalResource = ((IBeansConfig)originalInputElement).getElementResource();
                refresh = originalResource.equals((Object)changedResource);
            } else if (originalInputElement instanceof IBeansConfigSet) {
                refresh = ((IBeansConfigSet)originalInputElement).hasConfig((IFile)changedResource);
            }
            return refresh;
        }
    }

    private class GraphEditorPropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        private GraphEditorPropertyChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.springframework.ide.eclipse.beans.ui.shouldExtendedContent") || event.getProperty().equals("org.springframework.ide.eclipse.beans.ui.shouldShowInfrastructureBeans") || event.getProperty().equals("org.springframework.ide.eclipse.beans.ui.shouldShowInnerBeans")) {
                GraphEditor.this.initializeGraphicalViewer();
            }
        }
    }
}

