/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.service.JiraLocalConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import java.text.DateFormat;
import java.text.ParseException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateTimeAttributeEditor
extends AbstractAttributeEditor {
    private Text text;
    private final DateFormat format;

    public DateTimeAttributeEditor(TaskDataModel model, TaskAttribute taskAttribute, boolean includeTime) {
        super(model, taskAttribute);
        JiraLocalConfiguration configuration = JiraUtil.getLocalConfiguration((TaskRepository)model.getTaskRepository());
        this.format = includeTime ? configuration.getDateTimeFormat() : configuration.getDateFormat();
    }

    protected Text getText() {
        return this.text;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(this.getValue());
        } else {
            this.text = toolkit.createText(parent, this.getValue(), 0x800000);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DateTimeAttributeEditor.this.setValue(DateTimeAttributeEditor.this.text.getText());
                }
            });
        }
        toolkit.adapt((Control)this.text, false, false);
        this.setControl((Control)this.text);
    }

    public String getValue() {
        return this.format.format(this.getAttributeMapper().getDateValue(this.getTaskAttribute()));
    }

    public void setValue(String text) {
        try {
            this.getAttributeMapper().setDateValue(this.getTaskAttribute(), this.format.parse(text));
        }
        catch (ParseException parseException) {}
        this.attributeChanged();
    }
}

