/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.actions;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.ui.IJiraTask;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraUiUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.AbstractStartWorkAction;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.LogJiraTimeDialog;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.Messages;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.SelectWorkflowActionDialog;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraTaskEditorPage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkAction
extends AbstractStartWorkAction {
    private ITask task;
    private TaskData taskData;
    private JiraWorkLog workLog;

    @Override
    public void run(IAction action) {
        IFormPage formPage;
        TaskEditorInput taskEditorInput;
        TaskEditor taskEditor;
        IEditorInput editorInput;
        this.update(action);
        if (this.getTargetPart() instanceof TaskEditor && (editorInput = (taskEditor = (TaskEditor)this.getTargetPart()).getEditorInput()) instanceof TaskEditorInput && (taskEditorInput = (TaskEditorInput)editorInput).getTask().equals(this.task) && (formPage = taskEditor.getActivePageInstance()) instanceof JiraTaskEditorPage) {
            JiraTaskEditorPage jiraFormPage = (JiraTaskEditorPage)formPage;
            this.startWork(jiraFormPage);
            return;
        }
        this.startWork(null);
    }

    protected void run(JiraTaskEditorPage editorPage, TaskData taskData, ITask task) {
        this.taskData = taskData;
        this.task = task;
        this.startWork(editorPage);
    }

    private void startWork(JiraTaskEditorPage page) {
        Job job = null;
        if (StartWorkAction.isTaskInStop(this.taskData, this.task)) {
            job = StartWorkAction.getStartWorkJob(this.taskData, this.task);
        } else if (StartWorkAction.isTaskInProgress(this.taskData, this.task)) {
            if (!this.showLogWorkDialog(this.taskData, this.task)) {
                return;
            }
            job = StartWorkAction.getStopWorkJob(this.taskData, this.task, this.workLog);
        } else {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.jira.ui", Messages.StartWorkAction_cannot_perform));
            return;
        }
        if (page == null) {
            this.doActionOutsideEditor(job);
        } else {
            this.doActionInsideEditor(job, page);
        }
    }

    private static void synchronizeTask(final ITask task, IProgressMonitor monitor) {
        SynchronizeTasksJob job = (SynchronizeTasksJob)TasksUiPlugin.getTaskJobFactory().createSynchronizeTasksJob(StartWorkAction.getConnector(task), StartWorkAction.asSet(task));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (task instanceof AbstractTask && ((AbstractTask)task).getStatus() != null) {
                    TasksUiInternal.asyncDisplayStatus((String)org.eclipse.mylyn.internal.tasks.ui.util.Messages.TasksUiInternal_Task_Synchronization_Failed, (IStatus)((AbstractTask)task).getStatus());
                }
            }
        });
        job.run(monitor);
    }

    private static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    private void doActionInsideEditor(Job job, final JiraTaskEditorPage jiraFormPage) {
        if (jiraFormPage.isDirty()) {
            jiraFormPage.getEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
        jiraFormPage.showEditorBusy(true);
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        jiraFormPage.refresh();
                    }
                });
            }
        });
        job.schedule();
    }

    private void doActionOutsideEditor(Job job) {
        job.setUser(true);
        job.schedule();
    }

    private boolean showLogWorkDialog(TaskData taskData, ITask iTask) {
        if (MonitorUiPlugin.getDefault().isActivityTrackingEnabled()) {
            long seconds = JiraUiUtil.getLoggedActivityTime(iTask);
            LogJiraTimeDialog dialog = new LogJiraTimeDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), taskData, iTask, seconds);
            int result = dialog.open();
            if (result == 0) {
                this.workLog = dialog.getWorkLog();
            } else if (result == 1) {
                this.workLog = null;
            } else {
                return false;
            }
        }
        return true;
    }

    private static String showSelectActionDialog(TaskData taskData, ITask iTask, boolean start) {
        SelectWorkflowActionDialog dialog = new SelectWorkflowActionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), taskData, iTask, start);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getSelectedAction();
        }
        return null;
    }

    private static boolean smartAdvanceAction(final boolean start, JiraClient client, JiraIssue issue, final TaskData taskData, final ITask task, IProgressMonitor monitor) throws JiraException {
        final boolean[] doAdvanceAction = new boolean[]{false};
        final String[] selectedAction = new String[1];
        String string = selectedAction[0] = start ? "4" : "301";
        if (start && !StartWorkAction.haveStartProgressOperation(taskData) || !start && !StartWorkAction.haveStopProgressOperation(taskData)) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    selectedAction[0] = StartWorkAction.showSelectActionDialog(taskData, task, start);
                    doAdvanceAction[0] = selectedAction[0] != null;
                }
            });
        } else {
            doAdvanceAction[0] = true;
        }
        if (doAdvanceAction[0]) {
            client.advanceIssueWorkflow(issue, selectedAction[0], null, monitor);
            return true;
        }
        return false;
    }

    private static Job getStartWorkJob(final TaskData taskData, final ITask task) {
        Job startProgressJob = new Job(Messages.StartWorkAction_Start_Work){

            protected IStatus run(IProgressMonitor monitor) {
                block13: {
                    boolean shouldActivate;
                    block15: {
                        monitor.beginTask(String.valueOf(Messages.StartWorkAction_Starting_Work) + task.getTaskKey(), -1);
                        JiraClient client = StartWorkAction.getClient(task);
                        boolean shouldSynchronize = false;
                        shouldActivate = false;
                        try {
                            JiraIssue issue = StartWorkAction.getIssue(task);
                            if (!StartWorkAction.isAssignedToMe(taskData, task)) {
                                client.assignIssueTo(issue, StartWorkAction.getCurrentUser(task), null, monitor);
                                shouldSynchronize = true;
                            }
                            StartWorkAction.smartAdvanceAction(true, client, issue, taskData, task, monitor);
                            shouldSynchronize = true;
                            shouldActivate = true;
                        }
                        catch (CoreException e) {
                            StartWorkAction.handleError(String.valueOf(Messages.JiraConnectorUiActions_Cannot_get_task_data) + task.getTaskKey(), e);
                            if (shouldSynchronize) {
                                StartWorkAction.synchronizeTask(task, monitor);
                            }
                            if (shouldActivate) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(task){
                                    private final /* synthetic */ ITask val$task;
                                    {
                                        this.val$task = iTask;
                                    }

                                    public void run() {
                                        TasksUi.getTaskActivityManager().activateTask(this.val$task);
                                    }
                                });
                            }
                            break block13;
                        }
                        catch (JiraException e) {
                            block14: {
                                try {
                                    StartWorkAction.handleErrorWithDetails(String.valueOf(Messages.StartWorkAction_Start_Work_Failed) + task.getTaskKey(), e);
                                    if (!shouldSynchronize) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (shouldSynchronize) {
                                        StartWorkAction.synchronizeTask(task, monitor);
                                    }
                                    if (shouldActivate) {
                                        PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    throw throwable;
                                }
                                StartWorkAction.synchronizeTask(task, monitor);
                            }
                            if (shouldActivate) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            break block13;
                        }
                        if (!shouldSynchronize) break block15;
                        StartWorkAction.synchronizeTask(task, monitor);
                    }
                    if (shouldActivate) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        return startProgressJob;
    }

    private static Job getStopWorkJob(final TaskData taskData, final ITask task, final JiraWorkLog jiraWorkLog) {
        Job stopProgressJob = new Job(Messages.StartWorkAction_Stop_Work){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(Messages.StartWorkAction_Stoping_Work) + task.getTaskKey(), -1);
                JiraClient client = StartWorkAction.getClient(task);
                try {
                    JiraIssue issue = StartWorkAction.getIssue(task);
                    if (jiraWorkLog != null) {
                        client.addWorkLog(task.getTaskKey(), jiraWorkLog, monitor);
                        JiraUiUtil.setLoggedActivityTime(task);
                    }
                    StartWorkAction.smartAdvanceAction(false, client, issue, taskData, task, monitor);
                    StartWorkAction.synchronizeTask(task, monitor);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TasksUi.getTaskActivityManager().deactivateTask(task);
                        }
                    });
                }
                catch (CoreException e) {
                    StartWorkAction.handleError(String.valueOf(Messages.JiraConnectorUiActions_Cannot_get_task_data) + task.getTaskKey(), e);
                }
                catch (JiraException e) {
                    StartWorkAction.handleErrorWithDetails(String.valueOf(Messages.StartWorkAction_Stop_Work_Failed) + task.getTaskKey(), e);
                }
                return Status.OK_STATUS;
            }
        };
        return stopProgressJob;
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        this.task = null;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            for (Object sel : ss) {
                if (!(sel instanceof IJiraTask)) continue;
                this.task = ((IJiraTask)sel).getTask();
                try {
                    this.taskData = TasksUiPlugin.getTaskDataManager().getTaskData(this.task);
                }
                catch (CoreException e) {
                    StartWorkAction.handleError(String.valueOf(Messages.JiraConnectorUiActions_Cannot_get_task_data) + this.task.getTaskKey(), e);
                }
                break;
            }
        }
        this.update(action);
    }

    private void update(IAction action) {
        if (StartWorkAction.isTaskInProgress(this.taskData, this.task)) {
            action.setText(Messages.StartWorkAction_Stop_Work);
        } else if (StartWorkAction.isTaskInStop(this.taskData, this.task)) {
            action.setText(Messages.StartWorkAction_Start_Work);
        } else {
            action.setEnabled(false);
            action.setText(Messages.StartWorkAction_Start_Work);
        }
    }

    private static String getCurrentUser(ITask task) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        return repository.getUserName();
    }
}

