/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.ui.SpringUIImages;

public class SpringLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.springframework.ide.eclipse.ui.model.modelLabelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ISpringProject) {
            this.decorateModelElement((IModelElement)((ISpringProject)element), decoration);
        }
    }

    private void decorateModelElement(IModelElement element, IDecoration decoration) {
        this.addErrorOverlay(decoration, this.getSeverity(element));
    }

    protected final void addErrorOverlay(IDecoration decoration, int severity) {
        if (severity == 1) {
            decoration.addOverlay(SpringUIImages.DESC_OVR_WARNING, 2);
        } else if (severity == 2) {
            decoration.addOverlay(SpringUIImages.DESC_OVR_ERROR, 2);
        }
    }

    protected int getSeverity(Object element) {
        if (element instanceof ISpringProject) {
            return MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)((ISpringProject)element).getProject(), (int)-1, (int)-1);
        }
        return 0;
    }
}

