/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.ui.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.angularjs.core.utils.AngularDOMUtils;
import org.eclipse.angularjs.ui.style.AbstractAngularSemanticHighlighting;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DirectiveSemanticHighlighting
extends AbstractAngularSemanticHighlighting {
    @Override
    public String getStyleStringKey() {
        return "directiveName";
    }

    public String getEnabledPreferenceKey() {
        return "angularjs.ui.highlighting.directive.enabled";
    }

    @Override
    protected List<Position> consumes(IDOMNode node, IFile file, IStructuredDocumentRegion documentRegion) {
        if (this.isDirectiveElement(node, file)) {
            return this.consumesElement(documentRegion);
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            ArrayList<Position> positions = null;
            IDOMAttr attr = null;
            IDOMNode currentNode = null;
            int i = 0;
            while (i < attributes.getLength()) {
                currentNode = (IDOMNode)attributes.item(i);
                if (this.isDirectiveAttr(currentNode, file)) {
                    attr = (IDOMAttr)currentNode;
                    Position pos = new Position(attr.getNameRegionStartOffset(), attr.getNameRegionEndOffset() - attr.getNameRegionStartOffset());
                    if (positions == null) {
                        positions = new ArrayList<Position>();
                    }
                    positions.add(pos);
                }
                ++i;
            }
            return positions;
        }
        return null;
    }

    private boolean isDirectiveElement(IDOMNode node, IFile file) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (file == null) {
            return node.getNodeName().startsWith("ng");
        }
        return AngularDOMUtils.getAngularDirective((IProject)file.getProject(), (Element)((IDOMElement)node)) != null;
    }

    protected boolean isDirectiveAttr(IDOMNode node, IFile file) {
        if (node.getNodeType() != 2) {
            return false;
        }
        if (file == null) {
            return node.getNodeName().startsWith("ng");
        }
        return AngularDOMUtils.getAngularDirective((IProject)file.getProject(), (Attr)((IDOMAttr)node)) != null;
    }

    private List<Position> consumesElement(IStructuredDocumentRegion region) {
        ArrayList<Position> positions = null;
        ITextRegionList regionList = region.getRegions();
        int i = 0;
        while (i < regionList.size()) {
            ITextRegion textRegion = regionList.get(i);
            if (textRegion.getType().equals("XML_TAG_NAME")) {
                Position position = new Position(region.getStartOffset(textRegion), textRegion.getLength());
                if (positions == null) {
                    positions = new ArrayList<Position>();
                }
                positions.add(position);
            }
            ++i;
        }
        return positions;
    }
}

