/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.validation;

import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;

public abstract class AbstractNonInfrastructureBeanValidationRule {
    public final boolean supports(IModelElement element, IValidationContext context) {
        IBean bean = this.resolveBeanFromModelElement(element);
        return context instanceof IBeansValidationContext && (bean == null || bean != null && !bean.isInfrastructure()) && this.supportsModelElementForNonInfrastructureBean(element, (IBeansValidationContext)context);
    }

    private IBean resolveBeanFromModelElement(IModelElement element) {
        if (element instanceof IBean) {
            return (IBean)element;
        }
        if (element != null) {
            return this.resolveBeanFromModelElement(element.getElementParent());
        }
        return null;
    }

    protected boolean supportsModelElementForNonInfrastructureBean(IModelElement element, IBeansValidationContext context) {
        return true;
    }

    protected TypeHierarchyEngine getTypeHierarchyEngine(IBeansValidationContext context) {
        if (context instanceof AbstractValidationContext) {
            return ((AbstractValidationContext)context).getTypeHierarchyEngine();
        }
        return SpringCore.getTypeHierarchyEngine();
    }
}

