/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.BeansTags;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConnection;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansList;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansMap;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProperties;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IProfileAwareBeansComponent;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.SuperTypeHierarchyCache;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BeansModelUtils {
    public static IBean getBean(String name, IModelElement context) {
        if (context instanceof IBeansConfig) {
            IBeanAlias alias;
            IBeansConfig config = (IBeansConfig)context;
            IBean bean = config.getBean(name);
            if (bean == null && (alias = config.getAlias(name)) != null) {
                bean = config.getBean(alias.getBeanName());
            }
            if (bean == null) {
                for (IBeansComponent component : config.getComponents()) {
                    bean = BeansModelUtils.getBean(name, component);
                    if (bean == null) continue;
                    return bean;
                }
            }
            return bean;
        }
        if (context instanceof IBeansConfigSet) {
            IBeanAlias alias;
            IBeansConfigSet configSet = (IBeansConfigSet)context;
            IBean bean = configSet.getBean(name);
            if (bean == null && (alias = configSet.getAlias(name)) != null) {
                bean = configSet.getBean(alias.getBeanName());
            }
            if (bean == null) {
                for (IBeansComponent component : configSet.getComponents()) {
                    bean = BeansModelUtils.getBean(name, component);
                    if (bean == null) continue;
                    return bean;
                }
            }
            return bean;
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    private static IBean getBean(String name, IBeansComponent component) {
        for (IBean componentBean : component.getBeans()) {
            if (!componentBean.getElementName().equals(name)) continue;
            return componentBean;
        }
        for (IBeansComponent nestedComponent : component.getComponents()) {
            IBean bean = BeansModelUtils.getBean(name, nestedComponent);
            if (bean == null) continue;
            return bean;
        }
        return null;
    }

    public static String getBeanClass(IBean bean, IModelElement context) {
        Assert.notNull((Object)bean);
        if (context == null) {
            context = BeansModelUtils.getConfig(bean);
            String className = BeansModelUtils.getBeanClassFromContext(bean, context);
            if (className != null) {
                return className;
            }
            Set<IBeansConfigSet> configSets = BeansModelUtils.getConfigSets(bean);
            for (IBeansConfigSet configSet : configSets) {
                className = BeansModelUtils.getBeanClassFromContext(bean, configSet);
                if (className == null) continue;
                return className;
            }
        } else {
            return BeansModelUtils.getBeanClassFromContext(bean, context);
        }
        return null;
    }

    public static String getBeanClassFromContext(IBean bean, IModelElement context) {
        Assert.notNull((Object)bean);
        Assert.notNull((Object)context);
        if (bean.getClassName() != null) {
            return bean.getClassName();
        }
        HashSet<String> beanNames = new HashSet<String>();
        do {
            beanNames.add(bean.getElementName());
            String parentName = bean.getParentName();
            if (parentName != null) {
                if (beanNames.contains(parentName)) break;
                bean = BeansModelUtils.getBean(parentName, context);
                if (bean == null || bean.getClassName() == null) continue;
                return bean.getClassName();
            }
            bean = null;
        } while (bean != null);
        return null;
    }

    public static Set<BeansConnection> getBeanReferences(IModelElement element, IModelElement context, boolean recursive) {
        LinkedHashSet<BeansConnection> references = new LinkedHashSet<BeansConnection>();
        HashSet<IBean> referencedBeans = new HashSet<IBean>();
        return BeansModelUtils.getBeanReferences(element, context, recursive, references, referencedBeans);
    }

    public static Set<IBean> getBeans(IModelElement element) {
        return BeansModelUtils.getBeans(element, null);
    }

    public static Set<IBean> getBeans(IModelElement element, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final LinkedHashSet<IBean> beans = new LinkedHashSet<IBean>();
        if (element instanceof IBeansModel) {
            Set<IBeansProject> projects = ((IBeansModel)element).getProjects();
            monitor.beginTask("Locating bean definitions", projects.size());
            try {
                for (IBeansProject project : projects) {
                    monitor.subTask("Locating bean definitions in project '" + project.getElementName() + "'");
                    for (IBeansConfig config : project.getConfigs()) {
                        monitor.subTask("Locating bean defintions from file '" + config.getElementName() + "'");
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        config.accept(new IModelElementVisitor(){

                            public boolean visit(IModelElement element, IProgressMonitor monitor) {
                                if (element instanceof IBean) {
                                    beans.add((IBean)element);
                                }
                                return !monitor.isCanceled();
                            }
                        }, (IProgressMonitor)new NullProgressMonitor());
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            finally {
                monitor.done();
            }
        } else if (element instanceof IBeansProject) {
            Set<IBeansConfig> configs = ((IBeansProject)element).getConfigs();
            monitor.beginTask("Locating bean definitions", configs.size());
            try {
                for (IBeansConfig config : configs) {
                    monitor.subTask("Loading bean defintion from file '" + config.getElementName() + "'");
                    beans.addAll(config.getBeans());
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (IBeansComponent component : config.getComponents()) {
                        beans.addAll(component.getBeans());
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            finally {
                monitor.done();
            }
        } else if (element instanceof IBeansConfig) {
            beans.addAll(((IBeansConfig)element).getBeans());
            for (IBeansComponent component : ((IBeansConfig)element).getComponents()) {
                beans.addAll(BeansModelUtils.getBeans(component, monitor));
            }
        } else if (element instanceof IBeansConfigSet) {
            beans.addAll(((IBeansConfigSet)element).getBeans());
            for (IBeansComponent component : ((IBeansConfigSet)element).getComponents()) {
                beans.addAll(BeansModelUtils.getBeans(component, monitor));
            }
        } else if (element instanceof IBeansComponent) {
            for (IBeansComponent component : ((IBeansComponent)element).getComponents()) {
                beans.addAll(BeansModelUtils.getBeans(component, monitor));
            }
            beans.addAll(((IBeansComponent)element).getBeans());
        } else if (element instanceof IBean) {
            beans.add((IBean)element);
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        return beans;
    }

    public static IType getBeanType(IBean bean, IModelElement context) {
        Assert.notNull((Object)bean);
        String className = BeansModelUtils.getBeanClass(bean, context);
        if (className != null) {
            return JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)className);
        }
        return null;
    }

    public static IBean getBeanWithConfigSets(String name, IBeansConfig config) {
        IBean bean = BeansModelUtils.getBean(name, config);
        if (bean == null) {
            IBeansProject project = (IBeansProject)config.getElementParent();
            for (IBeansConfigSet configSet : project.getConfigSets()) {
                if (configSet.hasConfig(config.getElementName()) && (bean = BeansModelUtils.getBean(name, configSet)) != null) break;
            }
        }
        return bean;
    }

    public static IModelElement getChildForElement(IModelElement parent, IModelElement element) {
        while (element != null) {
            IModelElement elementParent = element.getElementParent();
            if (parent.equals(elementParent)) {
                return element;
            }
            element = elementParent;
        }
        return null;
    }

    public static IBeansConfig getConfig(IModelElement element) {
        if (element instanceof IBeansConfig) {
            return (IBeansConfig)element;
        }
        if (element instanceof ISourceModelElement) {
            while (!((element = element.getElementParent()) instanceof IBeansConfig)) {
            }
            return (IBeansConfig)element;
        }
        throw new IllegalArgumentException("Unsupported model element " + element);
    }

    public static IBeansConfig getConfig(String configName, IModelElement context) {
        if (configName.charAt(0) == '/') {
            int pos = configName.indexOf(47, 1);
            String projectName = configName.substring(1, pos);
            configName = configName.substring(pos + 1);
            IBeansProject project = BeansCorePlugin.getModel().getProject(projectName);
            if (project != null) {
                return project.getConfig(configName);
            }
        } else {
            if (context instanceof IBeansProject) {
                return ((IBeansProject)context).getConfig(configName);
            }
            if (context instanceof IBeansConfigSet) {
                return ((IBeansProject)context.getElementParent()).getConfig(configName);
            }
        }
        return null;
    }

    public static IBeansConfig getConfig(ZipEntryStorage storage) {
        IResourceModelElement parent = (IResourceModelElement)storage.getAdapter(IResourceModelElement.class);
        if (parent instanceof IBeansConfig) {
            return (IBeansConfig)parent;
        }
        IBeansProject project = BeansCorePlugin.getModel().getProject(storage.getFile().getProject());
        if (project != null) {
            return project.getConfig(storage.getFullName());
        }
        return null;
    }

    public static Set<IBeansConfigSet> getConfigSets(IModelElement element) {
        LinkedHashSet<IBeansConfigSet> configSets = new LinkedHashSet<IBeansConfigSet>();
        if (element instanceof IBeansConfigSet) {
            configSets.add((IBeansConfigSet)element);
        } else if (element instanceof IBeansConfig) {
            for (IBeansProject beansProject : BeansCorePlugin.getModel().getProjects()) {
                Set<IBeansConfigSet> css = beansProject.getConfigSets();
                for (IBeansConfigSet cs : css) {
                    if (!cs.getConfigs().contains(element)) continue;
                    configSets.add(cs);
                }
            }
        } else if (element instanceof ISourceModelElement) {
            IBeansConfig bc = BeansModelUtils.getConfig(element);
            for (IBeansProject beansProject : BeansCorePlugin.getModel().getProjects()) {
                Set<IBeansConfigSet> css = beansProject.getConfigSets();
                for (IBeansConfigSet cs : css) {
                    if (!cs.getConfigs().contains(bc)) continue;
                    configSets.add(cs);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        return configSets;
    }

    public static IFile getFile(IModelElement element) {
        IResource resource;
        if (element instanceof IResourceModelElement && (resource = ((IResourceModelElement)element).getElementResource()) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static IBeanConstructorArgument getFirstConstructorArgument(IBean bean) {
        IBeanConstructorArgument firstCarg = null;
        int firstCargStartLine = Integer.MAX_VALUE;
        for (IBeanConstructorArgument carg : bean.getConstructorArguments()) {
            if (carg.getElementStartLine() >= firstCargStartLine) continue;
            firstCarg = carg;
            firstCargStartLine = carg.getElementStartLine();
        }
        return firstCarg;
    }

    public static IBeansConfig getImportingBeansConfig(IBeansConfig beansConfig) {
        if (beansConfig instanceof IImportedBeansConfig) {
            return (IBeansConfig)beansConfig.getElementParent().getElementParent();
        }
        return null;
    }

    public static Set<IBean> getInnerBeans(final IModelElement element, final boolean recursive) {
        final HashSet<IBean> innerBeans = new HashSet<IBean>();
        IModelElementVisitor visitor = new IModelElementVisitor(){

            public boolean visit(IModelElement visitedElement, IProgressMonitor monitor) {
                if (!element.equals(visitedElement) && visitedElement instanceof IBean && ((IBean)visitedElement).isInnerBean()) {
                    innerBeans.add((IBean)visitedElement);
                    return recursive;
                }
                return true;
            }
        };
        element.accept(visitor, (IProgressMonitor)new NullProgressMonitor());
        return innerBeans;
    }

    public static Set<IBean> getInnerBeans(IModelElement element) {
        return BeansModelUtils.getInnerBeans(element, true);
    }

    public static BeanDefinition getMergedBeanDefinition(IBean bean, IModelElement context) {
        BeanDefinition bd = ((Bean)bean).getBeanDefinition();
        if (bean.isChildBean()) {
            if (context == null) {
                context = BeansModelUtils.getConfig(bean);
            }
            ArrayList<BeanDefinition> beanDefinitions = new ArrayList<BeanDefinition>();
            beanDefinitions.add(bd);
            BeansModelUtils.addBeanDefinition(bean, context, beanDefinitions);
            RootBeanDefinition rbd = null;
            int bdCount = beanDefinitions.size();
            int i = bdCount - 1;
            while (i >= 0) {
                BeanDefinition abd = (BeanDefinition)beanDefinitions.get(i);
                if (rbd != null) {
                    rbd.overrideFrom(abd);
                } else if (abd instanceof RootBeanDefinition) {
                    rbd = new RootBeanDefinition((RootBeanDefinition)abd);
                } else {
                    if (!(abd instanceof GenericBeanDefinition)) break;
                    rbd = new GenericBeanDefinition(abd);
                }
                --i;
            }
            if (rbd != null) {
                return rbd;
            }
        }
        return bd;
    }

    public static IModelElement getModelElement(Element element, IModelElement context) {
        IBean bean;
        String beanName;
        Node parent = element.getParentNode();
        if (BeansTags.isTag(element, BeansTags.Tag.BEAN) && BeansTags.isTag(parent, BeansTags.Tag.BEANS)) {
            String beanName2 = BeansModelUtils.getBeanName(element);
            if (beanName2 != null) {
                return BeansModelUtils.getBean(beanName2, context);
            }
        } else if (BeansTags.isTag(element, BeansTags.Tag.PROPERTY) && BeansTags.isTag(parent, BeansTags.Tag.BEAN) && BeansTags.isTag(parent.getParentNode(), BeansTags.Tag.BEANS) && (beanName = BeansModelUtils.getBeanName((Element)parent)) != null && (bean = BeansModelUtils.getBean(beanName, context)) != null) {
            Attr nameAttribute = element.getAttributeNode("name");
            if (nameAttribute != null && nameAttribute.getNodeValue() != null) {
                return bean.getProperty(nameAttribute.getNodeValue());
            }
            return bean;
        }
        return null;
    }

    public static IModelElement getMostSpecificModelElement(int startLine, int endLine, IFile resource, IProgressMonitor monitor) {
        if (BeansCoreUtils.isBeansConfig((IResource)resource, true)) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig(resource, true);
            ModelElementDetermingModelVisitor v = new ModelElementDetermingModelVisitor(startLine, endLine, resource);
            beansConfig.accept(v, monitor);
            return v.getElement();
        }
        return null;
    }

    public static <T> T getParentOfClass(IModelElement child, Class<T> parentType) {
        if (child != null) {
            IModelElement parent = child.getElementParent();
            while (parent != null) {
                if (parentType.isAssignableFrom(parent.getClass())) {
                    return (T)parent;
                }
                parent = parent.getElementParent();
            }
        }
        return null;
    }

    public static IBeansProject getProject(IModelElement element) {
        IResource resource;
        IBeansProject project = BeansModelUtils.getParentOfClass(element, IBeansProject.class);
        if (project != null) {
            return project;
        }
        if (element instanceof IResourceModelElement && (resource = ((IResourceModelElement)element).getElementResource()) != null && (project = BeansCorePlugin.getModel().getProject(resource.getProject())) != null) {
            return project;
        }
        throw new IllegalArgumentException("Unsupported model element " + element);
    }

    public static IMethod getPropertyMethod(IBeanProperty property, IModelElement context) {
        Assert.notNull((Object)property);
        IType type = BeansModelUtils.getBeanType((IBean)property.getElementParent(), context);
        if (type != null) {
            try {
                return Introspector.getWritableProperty((IType)type, (String)property.getElementName());
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return null;
    }

    public static IResourceModelElement getResourceModelElement(Object obj) {
        if (obj instanceof IFile) {
            return BeansCorePlugin.getModel().getConfig((IFile)obj);
        }
        if (obj instanceof IProject) {
            return BeansCorePlugin.getModel().getProject((IProject)obj);
        }
        if (obj instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            if (resource instanceof IFile) {
                return BeansCorePlugin.getModel().getConfig((IFile)resource);
            }
            if (resource instanceof IProject) {
                return BeansCorePlugin.getModel().getConfig((IFile)obj);
            }
        }
        return null;
    }

    public static String getValueName(Object value) {
        if (value instanceof BeanDefinitionHolder) {
            value = ((BeanDefinitionHolder)value).getBeanDefinition();
        }
        StringBuffer name = new StringBuffer();
        if (value instanceof String) {
            name.append('\"').append(value).append('\"');
        } else if (value instanceof BeanDefinition) {
            name.append("bean ");
            if (value instanceof RootBeanDefinition) {
                name.append('[');
                name.append(((RootBeanDefinition)value).getBeanClassName());
                name.append(']');
            } else {
                name.append('<');
                name.append(((BeanDefinition)value).getParentName());
                name.append('>');
            }
        } else if (value instanceof RuntimeBeanReference) {
            name.append("reference ");
            String beanName = ((RuntimeBeanReference)value).getBeanName();
            name.append('<').append(beanName).append(">");
        } else if (value != null) {
            String valueName = null;
            valueName = value.getClass().isArray() ? "[" + StringUtils.arrayToDelimitedString((Object[])((Object[])value), (String)", ") + "]" : value.toString();
            if (valueName.length() > 30) {
                name.append(valueName.substring(0, 12)).append(" .. ").append(valueName.substring(valueName.length() - 13));
            } else {
                name.append(valueName);
            }
        } else {
            name.append("<null>");
        }
        return name.toString();
    }

    public static boolean isBeanClass(String className) {
        Set<IBeansConfig> beans = BeansCorePlugin.getModel().getConfigs(className);
        return beans != null && beans.size() > 0;
    }

    public static boolean isBeanClass(IType type) {
        for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project.getProject());
            if (javaProject == null || !javaProject.isOnClasspath((IJavaElement)type)) continue;
            for (IBeansConfig config : project.getConfigs()) {
                if (!config.isBeanClass(type.getFullyQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInnerBean(IBean bean) {
        return !(bean.getElementParent() instanceof IBeansConfig);
    }

    public static void register(IBeansConfigSet configSet, IBeansConfig config, BeanDefinitionRegistry registry) {
        for (IBeanAlias alias : config.getAliases()) {
            try {
                registry.registerAlias(alias.getBeanName(), alias.getElementName());
            }
            catch (BeansException beansException) {}
        }
        for (IBean bean : config.getBeans()) {
            String beanName = bean.getElementName();
            try {
                registry.registerBeanDefinition(beanName, ((Bean)bean).getBeanDefinition());
            }
            catch (BeansException beansException) {}
            String[] aliases = bean.getAliases();
            if (aliases == null) continue;
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                try {
                    registry.registerAlias(beanName, alias);
                }
                catch (BeansException beansException) {}
                ++n2;
            }
        }
        BeansModelUtils.registerComponents(configSet, config.getComponents(), registry);
    }

    public static Object resolveValueIfNecessary(ISourceModelElement parent, Object value) {
        if (value instanceof IModelElement) {
            return value;
        }
        if (value instanceof BeanDefinitionHolder) {
            return new Bean((IModelElement)parent, (BeanDefinitionHolder)value);
        }
        if (value instanceof BeanDefinition) {
            return new Bean((IModelElement)parent, "(inner bean)", null, (BeanDefinition)value);
        }
        if (value instanceof RuntimeBeanNameReference) {
            return new BeanReference(parent, (org.springframework.beans.factory.config.BeanReference)((RuntimeBeanNameReference)value));
        }
        if (value instanceof RuntimeBeanReference) {
            return new BeanReference(parent, (org.springframework.beans.factory.config.BeanReference)((RuntimeBeanReference)value));
        }
        if (value instanceof ManagedList) {
            return new BeansList((IModelElement)parent, (ManagedList)value);
        }
        if (value instanceof ManagedSet) {
            return new BeansSet((IModelElement)parent, (ManagedSet)value);
        }
        if (value instanceof ManagedMap) {
            return new BeansMap((IModelElement)parent, (ManagedMap)value);
        }
        if (value instanceof ManagedProperties) {
            return new BeansProperties((IModelElement)parent, (ManagedProperties)value);
        }
        if (value instanceof TypedStringValue) {
            return new BeansTypedString((IModelElement)parent, (TypedStringValue)value);
        }
        if (value != null && value.getClass().isArray()) {
            return new BeansTypedString(parent, "[" + StringUtils.arrayToDelimitedString((Object[])((Object[])value), (String)", ") + "]");
        }
        return new BeansTypedString(parent, value != null ? value.toString() : "null");
    }

    private static void addBeanDefinition(IBean bean, IModelElement context, List<BeanDefinition> beanDefinitions) {
        String parentName = bean.getParentName();
        Bean parentBean = (Bean)BeansModelUtils.getBean(parentName, context);
        if (parentBean != null) {
            BeanDefinition parentBd = parentBean.getBeanDefinition();
            if (!parentName.equals(bean.getElementName()) && !beanDefinitions.contains(parentBd)) {
                beanDefinitions.add(parentBd);
                if (parentBean.isChildBean()) {
                    BeansModelUtils.addBeanDefinition(parentBean, context, beanDefinitions);
                }
            }
        }
    }

    private static boolean addBeanReference(BeansConnection.BeanType type, IModelElement source, IBean target, IModelElement context, Set<BeansConnection> references, Set<IBean> referencedBeans) {
        BeansConnection ref;
        if (target != null && target != source && !references.contains(ref = new BeansConnection(type, source, target, context))) {
            references.add(ref);
            if (!referencedBeans.contains(target)) {
                return true;
            }
        }
        return false;
    }

    private static void addBeanReferencesForBean(IBean element, IModelElement context, boolean recursive, Set<BeansConnection> references, Set<IBean> referencedBeans) {
        if (!referencedBeans.contains(element)) {
            referencedBeans.add(element);
            for (BeansConnection ref : BeansModelUtils.getBeanReferences(element, context, recursive, references, referencedBeans)) {
                if (references.contains(ref)) continue;
                references.add(ref);
            }
        }
    }

    private static void addBeanReferencesForBeansComponent(IBeansComponent component, IModelElement context, boolean recursive, Set<BeansConnection> references, Set<IBean> referencedBeans) {
        for (IBean bean : component.getBeans()) {
            BeansModelUtils.addBeanReferencesForBean(bean, context, recursive, references, referencedBeans);
        }
        for (IBeansComponent innerComponent : component.getComponents()) {
            BeansModelUtils.addBeanReferencesForBeansComponent(innerComponent, context, recursive, references, referencedBeans);
        }
    }

    private static void addBeanReferencesForValue(IModelElement element, Object value, IModelElement context, Set<BeansConnection> references, Set<IBean> referencedBeans, boolean recursive) {
        block10: {
            block11: {
                block12: {
                    block9: {
                        if (!(value instanceof IBeanReference)) break block9;
                        String beanName = ((IBeanReference)value).getBeanName();
                        IBean bean = BeansModelUtils.getBean(beanName, context);
                        if (!BeansModelUtils.addBeanReference(BeansConnection.BeanType.STANDARD, element, bean, context, references, referencedBeans) || !recursive) break block10;
                        BeansModelUtils.addBeanReferencesForBean(bean, context, recursive, references, referencedBeans);
                        break block10;
                    }
                    if (!(value instanceof IBeansList)) break block11;
                    if (!(element instanceof IBeanProperty) || !element.getElementName().equals("interceptorNames")) break block12;
                    IType type = BeansModelUtils.getBeanType((IBean)element.getElementParent(), context);
                    if (type == null || !type.getFullyQualifiedName().equals("org.springframework.aop.framework.ProxyFactoryBean")) break block10;
                    IModelElement[] iModelElementArray = ((IBeansList)value).getElementChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBean interceptor;
                        IModelElement child = iModelElementArray[n2];
                        if (child instanceof IBeansTypedString && BeansModelUtils.addBeanReference(BeansConnection.BeanType.INTERCEPTOR, element, interceptor = BeansModelUtils.getBean(((IBeansTypedString)child).getString(), context), context, references, referencedBeans) && recursive) {
                            BeansModelUtils.addBeanReferencesForBean(interceptor, context, recursive, references, referencedBeans);
                        }
                        ++n2;
                    }
                    break block10;
                }
                IModelElement[] iModelElementArray = ((IBeansList)value).getElementChildren();
                int n = iModelElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelElement child = iModelElementArray[n3];
                    BeansModelUtils.addBeanReferencesForValue(element, child, context, references, referencedBeans, recursive);
                    ++n3;
                }
                break block10;
            }
            if (value instanceof IBeansSet) {
                IModelElement[] iModelElementArray = ((IBeansSet)value).getElementChildren();
                int n = iModelElementArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IModelElement child = iModelElementArray[n4];
                    BeansModelUtils.addBeanReferencesForValue(element, child, context, references, referencedBeans, recursive);
                    ++n4;
                }
            } else if (value instanceof IBeansMap) {
                IModelElement[] iModelElementArray = ((IBeansMap)value).getElementChildren();
                int n = iModelElementArray.length;
                int n5 = 0;
                while (n5 < n) {
                    IModelElement child = iModelElementArray[n5];
                    if (child instanceof IBeansMapEntry) {
                        BeansModelUtils.addBeanReferencesForValue(element, ((IBeansMapEntry)child).getKey(), context, references, referencedBeans, recursive);
                        BeansModelUtils.addBeanReferencesForValue(element, ((IBeansMapEntry)child).getValue(), context, references, referencedBeans, recursive);
                    }
                    ++n5;
                }
            }
        }
    }

    private static String getBeanName(Element element) {
        Attr idAttribute = element.getAttributeNode("id");
        if (idAttribute != null && idAttribute.getNodeValue() != null) {
            return idAttribute.getNodeValue();
        }
        Attr nameAttribute = element.getAttributeNode("name");
        if (nameAttribute != null && nameAttribute.getNodeValue() != null) {
            return nameAttribute.getNodeValue();
        }
        return null;
    }

    private static Set<BeansConnection> getBeanReferences(IModelElement element, IModelElement context, boolean recursive, Set<BeansConnection> references, Set<IBean> referencedBeans) {
        if (element instanceof IBeansComponent) {
            BeansModelUtils.addBeanReferencesForBeansComponent((IBeansComponent)element, context, recursive, references, referencedBeans);
        } else if (element instanceof Bean) {
            IBean factoryBean;
            AbstractBeanDefinition bd;
            IBean parentBean;
            Bean bean = (Bean)element;
            if (bean.isChildBean() && BeansModelUtils.addBeanReference(BeansConnection.BeanType.PARENT, bean, parentBean = BeansModelUtils.getBean(bean.getParentName(), context), context, references, referencedBeans) && recursive) {
                HashSet<String> beanNames = new HashSet<String>();
                beanNames.add(bean.getElementName());
                beanNames.add(parentBean.getElementName());
                while (parentBean != null && parentBean.isChildBean()) {
                    String parentName = parentBean.getParentName();
                    if (beanNames.contains(parentName)) break;
                    beanNames.add(parentName);
                    parentBean = BeansModelUtils.getBean(parentName, context);
                    if (!BeansModelUtils.addBeanReference(BeansConnection.BeanType.PARENT, bean, parentBean, context, references, referencedBeans) || !recursive) continue;
                    BeansModelUtils.addBeanReferencesForBean(parentBean, context, recursive, references, referencedBeans);
                }
            }
            if ((bd = recursive ? (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, context) : (AbstractBeanDefinition)bean.getBeanDefinition()).getFactoryBeanName() != null && BeansModelUtils.addBeanReference(BeansConnection.BeanType.FACTORY, bean, factoryBean = BeansModelUtils.getBean(bd.getFactoryBeanName(), context), context, references, referencedBeans) && recursive) {
                BeansModelUtils.addBeanReferencesForBean(factoryBean, context, recursive, references, referencedBeans);
            }
            if (bd.getDependsOn() != null) {
                String[] stringArray = bd.getDependsOn();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dependsOnBeanId = stringArray[n2];
                    IBean dependsOnBean = BeansModelUtils.getBean(dependsOnBeanId, context);
                    if (BeansModelUtils.addBeanReference(BeansConnection.BeanType.DEPENDS_ON, bean, dependsOnBean, context, references, referencedBeans) && recursive) {
                        BeansModelUtils.addBeanReferencesForBean(dependsOnBean, context, recursive, references, referencedBeans);
                    }
                    ++n2;
                }
            }
            if (!bd.getMethodOverrides().isEmpty()) {
                for (IBeanConstructorArgument methodOverride : bd.getMethodOverrides().getOverrides()) {
                    String beanName;
                    IBean overrideBean;
                    if (methodOverride instanceof LookupOverride) {
                        String beanName2 = ((LookupOverride)methodOverride).getBeanName();
                        overrideBean = BeansModelUtils.getBean(beanName2, context);
                        if (!BeansModelUtils.addBeanReference(BeansConnection.BeanType.METHOD_OVERRIDE, bean, overrideBean, context, references, referencedBeans) || !recursive) continue;
                        BeansModelUtils.addBeanReferencesForBean(overrideBean, context, recursive, references, referencedBeans);
                        continue;
                    }
                    if (!(methodOverride instanceof ReplaceOverride) || !BeansModelUtils.addBeanReference(BeansConnection.BeanType.METHOD_OVERRIDE, bean, overrideBean = BeansModelUtils.getBean(beanName = ((ReplaceOverride)methodOverride).getMethodReplacerBeanName(), context), context, references, referencedBeans) || !recursive) continue;
                    BeansModelUtils.addBeanReferencesForBean(overrideBean, context, recursive, references, referencedBeans);
                }
            }
            for (IBeanConstructorArgument carg : bean.getConstructorArguments()) {
                BeansModelUtils.addBeanReferencesForValue(carg, carg.getValue(), context, references, referencedBeans, recursive);
            }
            for (IBeanProperty property : bean.getProperties()) {
                BeansModelUtils.addBeanReferencesForValue(property, property.getValue(), context, references, referencedBeans, recursive);
            }
            for (IBean nestedBean : BeansModelUtils.getInnerBeans(bean, false)) {
                Set<BeansConnection> nestedConnections = BeansModelUtils.getBeanReferences(nestedBean, context, false);
                for (BeansConnection nestedConnection : nestedConnections) {
                    references.add(new BeansConnection(nestedConnection.getType(), (IModelElement)bean, nestedConnection.getTarget(), true));
                }
            }
        } else if (element instanceof IBeanConstructorArgument) {
            IBeanConstructorArgument carg = (IBeanConstructorArgument)element;
            BeansModelUtils.addBeanReferencesForValue(carg, carg.getValue(), context, references, referencedBeans, recursive);
        } else if (element instanceof IBeanProperty) {
            IBeanProperty property = (IBeanProperty)element;
            BeansModelUtils.addBeanReferencesForValue(property, property.getValue(), context, references, referencedBeans, recursive);
        } else {
            throw new IllegalArgumentException("Unsupported model element " + element);
        }
        return references;
    }

    private static void registerComponents(IBeansConfigSet configSet, Set<IBeansComponent> components, BeanDefinitionRegistry registry) {
        for (IBeansComponent component : components) {
            if (BeansModelUtils.isProfileDisabled(configSet, component)) continue;
            for (IBean bean : component.getBeans()) {
                try {
                    String beanName = bean.getElementName();
                    registry.registerBeanDefinition(beanName, ((Bean)bean).getBeanDefinition());
                    String[] aliases = bean.getAliases();
                    if (aliases == null) continue;
                    String[] stringArray = aliases;
                    int n = aliases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String alias = stringArray[n2];
                        registry.registerAlias(beanName, alias);
                        ++n2;
                    }
                }
                catch (BeansException beansException) {}
            }
            BeansModelUtils.registerComponents(configSet, component.getComponents(), registry);
        }
    }

    public static boolean isProfileDisabled(IResourceModelElement contextElement, IModelElement beansComponent) {
        if (contextElement != null && contextElement instanceof IBeansConfigSet && beansComponent != null && beansComponent instanceof IProfileAwareBeansComponent) {
            IProfileAwareBeansComponent profileAwareBeansComponent = (IProfileAwareBeansComponent)beansComponent;
            IBeansConfigSet configSet = (IBeansConfigSet)contextElement;
            if (profileAwareBeansComponent.getProfiles().size() != 0 && !CollectionUtils.containsAny(profileAwareBeansComponent.getProfiles(), configSet.getProfiles())) {
                return true;
            }
        }
        return false;
    }

    public static Set<IBeansConfig> getConfigsByContainingTypes(IResource resource, TypeHierarchyEngine typeEngine, IProgressMonitor monitor) {
        if (System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true")) {
            return BeansModelUtils.getConfigsByContainingTypesUsingTypeHierarchyEngine(resource, typeEngine, monitor);
        }
        return BeansModelUtils.getConfigsByContainingTypesJDT(resource, monitor);
    }

    protected static Set<IBeansConfig> getConfigsByContainingTypesUsingTypeHierarchyEngine(IResource resource, TypeHierarchyEngine typeEngine, IProgressMonitor monitor) {
        IJavaElement element;
        Set<IBeansProject> projects;
        LinkedHashSet<IBeansConfig> files = new LinkedHashSet<IBeansConfig>();
        if (resource != null && resource.isAccessible() && resource.isSynchronized(0) && resource.getName().endsWith(".java") && (projects = BeansCorePlugin.getModel().getProjects()) != null && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit && element.getJavaProject().isOnClasspath(element)) {
            try {
                IType[] types = ((ICompilationUnit)element).getAllTypes();
                String[] changedTypeNames = new String[types.length];
                boolean[] changedTypeIsInterface = new boolean[types.length];
                int i = 0;
                while (i < types.length) {
                    changedTypeNames[i] = types[i].getFullyQualifiedName();
                    changedTypeIsInterface[i] = types[i].isInterface();
                    ++i;
                }
                for (IBeansProject project : projects) {
                    if (project == null || JdtUtils.isJavaProject((IResource)project.getProject()) && !JdtUtils.getJavaProject((IProject)project.getProject()).isOnClasspath(element)) continue;
                    Set<IBeansConfig> configs = project.getConfigs();
                    block4: for (IBeansConfig config : configs) {
                        boolean configAdded = false;
                        Set allBeanClasses = config.getBeanClasses();
                        int i2 = 0;
                        while (i2 < changedTypeNames.length) {
                            for (String className : allBeanClasses) {
                                if (changedTypeIsInterface[i2] && typeEngine.doesImplement(className, changedTypeNames[i2], project.getProject())) {
                                    files.add(config);
                                    configAdded = true;
                                    break;
                                }
                                if (changedTypeIsInterface[i2] || !typeEngine.doesExtend(className, changedTypeNames[i2], project.getProject())) continue;
                                files.add(config);
                                configAdded = true;
                                break;
                            }
                            if (configAdded) continue block4;
                            ++i2;
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return files;
    }

    protected static Set<IBeansConfig> getConfigsByContainingTypesJDT(IResource resource, IProgressMonitor monitor) {
        IJavaElement element;
        Set<IBeansProject> projects;
        LinkedHashSet<IBeansConfig> files = new LinkedHashSet<IBeansConfig>();
        if (resource != null && resource.isAccessible() && resource.isSynchronized(0) && resource.getName().endsWith(".java") && (projects = BeansCorePlugin.getModel().getProjects()) != null && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit && element.getJavaProject().isOnClasspath(element)) {
            try {
                IType[] types = ((ICompilationUnit)element).getAllTypes();
                HashSet<List<IType>> hierachies = new HashSet<List<IType>>();
                List<IType> relevantTypes = Arrays.asList(types);
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IType[] subTypes = SuperTypeHierarchyCache.getTypeHierarchy((IType)type, (IProgressMonitor)monitor).getAllSubtypes(type);
                    if (subTypes != null && subTypes.length > 0) {
                        hierachies.add(Arrays.asList(subTypes));
                    }
                    ++n2;
                }
                for (IBeansProject project : projects) {
                    if (project == null) continue;
                    Set<IBeansConfig> configs = project.getConfigs();
                    block4: for (IBeansConfig config : configs) {
                        Set allBeanClasses = config.getBeanClasses();
                        for (String className : allBeanClasses) {
                            IType type = JdtUtils.getJavaType((IProject)project.getProject(), (String)className);
                            if (type == null) continue;
                            if (relevantTypes.contains(type)) {
                                files.add(config);
                            } else {
                                for (List list : hierachies) {
                                    if (!list.contains(type)) continue;
                                    files.add(config);
                                    break;
                                }
                            }
                            if (files.contains(config)) continue block4;
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return files;
    }

    public static Set<IBean> getBeansByContainingTypes(IResource resource, TypeHierarchyEngine typeEngine, IProgressMonitor monitor) {
        if (System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true")) {
            return BeansModelUtils.getBeansByContainingTypesUsingTypeHierarchyEngine(resource, typeEngine, monitor);
        }
        return BeansModelUtils.getBeansByContainingTypesJDT(resource, monitor);
    }

    protected static Set<IBean> getBeansByContainingTypesUsingTypeHierarchyEngine(IResource resource, TypeHierarchyEngine typeEngine, IProgressMonitor monitor) {
        IJavaElement element;
        Set<IBeansProject> projects;
        LinkedHashSet<IBean> files = new LinkedHashSet<IBean>();
        if (resource != null && resource.isAccessible() && resource.isSynchronized(0) && resource.getName().endsWith(".java") && (projects = BeansCorePlugin.getModel().getProjects()) != null && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit && element.getJavaProject().isOnClasspath(element)) {
            try {
                IType[] types = ((ICompilationUnit)element).getAllTypes();
                String[] changedTypeNames = new String[types.length];
                boolean[] changedTypeIsInterface = new boolean[types.length];
                int i = 0;
                while (i < types.length) {
                    changedTypeNames[i] = types[i].getFullyQualifiedName();
                    changedTypeIsInterface[i] = types[i].isInterface();
                    ++i;
                }
                for (IBeansProject project : projects) {
                    if (project == null || JdtUtils.isJavaProject((IResource)project.getProject()) && !JdtUtils.getJavaProject((IProject)project.getProject()).isOnClasspath(element)) continue;
                    Set<IBeansConfig> configs = project.getConfigs();
                    for (IBeansConfig config : configs) {
                        Set<IBean> allBeans = BeansModelUtils.getBeans(config);
                        block5: for (IBean bean : allBeans) {
                            String className = BeansModelUtils.resolveBeanTypeAsString(bean);
                            if (className != null) {
                                int i2 = 0;
                                while (i2 < changedTypeNames.length) {
                                    if (changedTypeIsInterface[i2] && typeEngine.doesImplement(className, changedTypeNames[i2], project.getProject())) {
                                        files.add(bean);
                                        continue block5;
                                    }
                                    if (!changedTypeIsInterface[i2] && typeEngine.doesExtend(className, changedTypeNames[i2], project.getProject())) {
                                        files.add(bean);
                                        continue block5;
                                    }
                                    ++i2;
                                }
                                continue;
                            }
                            if (project == null || !JdtUtils.isJavaProject((IResource)project.getProject()) || !JdtUtils.getJavaProject((IProject)project.getProject()).isOnClasspath(resource)) continue;
                            files.add(bean);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return files;
    }

    protected static Set<IBean> getBeansByContainingTypesJDT(IResource resource, IProgressMonitor monitor) {
        IJavaElement element;
        Set<IBeansProject> projects;
        LinkedHashSet<IBean> files = new LinkedHashSet<IBean>();
        if (resource != null && resource.isAccessible() && resource.isSynchronized(0) && resource.getName().endsWith(".java") && (projects = BeansCorePlugin.getModel().getProjects()) != null && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit && element.getJavaProject().isOnClasspath(element)) {
            try {
                IType[] types = ((ICompilationUnit)element).getAllTypes();
                HashSet<List<IType>> hierachies = new HashSet<List<IType>>();
                List<IType> relevantTypes = Arrays.asList(types);
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IType[] subTypes = SuperTypeHierarchyCache.getTypeHierarchy((IType)type, (IProgressMonitor)monitor).getAllSubtypes(type);
                    if (subTypes != null && subTypes.length > 0) {
                        hierachies.add(Arrays.asList(subTypes));
                    }
                    ++n2;
                }
                for (IBeansProject project : projects) {
                    if (project == null) continue;
                    Set<IBeansConfig> configs = project.getConfigs();
                    for (IBeansConfig config : configs) {
                        Set<IBean> allBeans = BeansModelUtils.getBeans(config);
                        block5: for (IBean bean : allBeans) {
                            IType type = BeansModelUtils.resolveBeanType(bean);
                            if (type != null) {
                                if (relevantTypes.contains(type)) {
                                    files.add(bean);
                                    continue;
                                }
                                for (List list : hierachies) {
                                    if (!list.contains(type)) continue;
                                    files.add(bean);
                                    continue block5;
                                }
                                continue;
                            }
                            if (project == null || !JdtUtils.isJavaProject((IResource)project.getProject()) || !JdtUtils.getJavaProject((IProject)project.getProject()).isOnClasspath(resource)) continue;
                            files.add(bean);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return files;
    }

    public static IType resolveBeanType(IBean bean) {
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, null);
        String mergedClassName = mergedBd.getBeanClassName();
        return BeansModelUtils.extractBeanClass((BeanDefinition)mergedBd, bean, mergedClassName, BeansModelUtils.getParentOfClass(bean, IBeansConfig.class));
    }

    private static IType extractBeanClass(BeanDefinition bd, IBean bean, String mergedClassName, IBeansConfig beansConfig) {
        IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)mergedClassName);
        if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() == null) {
            type = BeansModelUtils.extractTypeFromFactoryMethod(bd, type);
        } else if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() != null) {
            try {
                BeanDefinition factoryBd;
                IType factoryBeanType;
                IBean factoryB = BeansModelUtils.getBeanWithConfigSets(bd.getFactoryBeanName(), beansConfig);
                if (factoryB != null && (factoryBeanType = BeansModelUtils.extractBeanClass(factoryBd = BeansModelUtils.getMergedBeanDefinition(factoryB, null), bean, factoryBd.getBeanClassName(), beansConfig)) != null) {
                    type = BeansModelUtils.extractTypeFromFactoryMethod(bd, factoryBeanType);
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        return type;
    }

    public static String resolveBeanTypeAsString(IBean bean) {
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, null);
        String mergedClassName = mergedBd.getBeanClassName();
        return BeansModelUtils.extractBeanClassAsString((BeanDefinition)mergedBd, bean, mergedClassName, BeansModelUtils.getParentOfClass(bean, IBeansConfig.class));
    }

    private static String extractBeanClassAsString(BeanDefinition bd, IBean bean, String mergedClassName, IBeansConfig beansConfig) {
        String result = mergedClassName;
        if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() == null) {
            IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)mergedClassName);
            result = BeansModelUtils.extractTypeFromFactoryMethodAsString(bd, type);
            if (result == null) {
                result = mergedClassName;
            }
        } else if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() != null) {
            try {
                IType factoryBeanType;
                BeanDefinition factoryBd;
                String factoryBeanTypeName;
                IBean factoryB = BeansModelUtils.getBeanWithConfigSets(bd.getFactoryBeanName(), beansConfig);
                if (factoryB != null && (factoryBeanTypeName = BeansModelUtils.extractBeanClassAsString(factoryBd = BeansModelUtils.getMergedBeanDefinition(factoryB, null), bean, factoryBd.getBeanClassName(), beansConfig)) != null && (result = BeansModelUtils.extractTypeFromFactoryMethodAsString(bd, factoryBeanType = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)factoryBeanTypeName))) == null) {
                    result = factoryBeanTypeName;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        return result;
    }

    private static String extractTypeFromFactoryMethodAsString(BeanDefinition bd, IType type) {
        String factoryMethod = bd.getFactoryMethodName();
        try {
            int argCount = !bd.isAbstract() ? bd.getConstructorArgumentValues().getArgumentCount() : -1;
            Set methods = Introspector.getAllMethods((IType)type);
            for (IMethod method : methods) {
                if (!factoryMethod.equals(method.getElementName()) || method.getParameterNames().length != argCount) continue;
                return JdtUtils.resolveClassNameBySignature((String)method.getReturnType(), (IType)type);
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private static IType extractTypeFromFactoryMethod(BeanDefinition bd, IType type) {
        String factoryMethod = bd.getFactoryMethodName();
        try {
            int argCount = !bd.isAbstract() ? bd.getConstructorArgumentValues().getArgumentCount() : -1;
            Set methods = Introspector.getAllMethods((IType)type);
            for (IMethod method : methods) {
                if (!factoryMethod.equals(method.getElementName()) || method.getParameterNames().length != argCount) continue;
                type = JdtUtils.getJavaTypeFromSignatureClassName((String)method.getReturnType(), (IType)type);
                break;
            }
        }
        catch (JavaModelException javaModelException) {}
        return type;
    }

    private static class ModelElementDetermingModelVisitor
    implements IModelElementVisitor {
        private int startLine;
        private int endLine;
        private final IFile file;
        private IModelElement element;

        public ModelElementDetermingModelVisitor(int startLine, int endLine, IFile file) {
            this.startLine = startLine + 1 == endLine ? startLine + 1 : startLine;
            this.endLine = endLine;
            this.file = file;
        }

        public IModelElement getElement() {
            return this.element;
        }

        public boolean visit(IModelElement element, IProgressMonitor monitor) {
            if (element instanceof ISourceModelElement) {
                ISourceModelElement sourceElement = (ISourceModelElement)element;
                if (sourceElement.getElementResource().equals((Object)this.file) && (sourceElement.getElementStartLine() <= this.startLine || sourceElement.getElementStartLine() - 1 <= this.startLine) && this.endLine <= sourceElement.getElementEndLine()) {
                    this.element = element;
                    if (sourceElement.getElementStartLine() == this.startLine && this.endLine == sourceElement.getElementEndLine()) {
                        this.startLine = -1;
                        this.endLine = -1;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return element instanceof IBeansConfig;
        }
    }
}

