/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class ProjectAwareUrlStreamHandlerService
extends AbstractURLStreamHandlerService {
    public static final String PROJECT_AWARE_PROTOCOL = "project-aware";
    public static final String PROJECT_AWARE_PROTOCOL_HEADER = "project-aware://";

    public URLConnection openConnection(URL u) throws IOException {
        String systemId = u.toString();
        String nameAndLocation = systemId.substring(PROJECT_AWARE_PROTOCOL_HEADER.length());
        String projectName = nameAndLocation.substring(0, nameAndLocation.indexOf(47));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String resourceId = nameAndLocation.substring(nameAndLocation.indexOf(47) + 1);
        ClassLoader cl = JdtUtils.getClassLoader((IProject)project, null);
        URL resource = cl.getResource(resourceId);
        if (resource != null) {
            return resource.openConnection();
        }
        return null;
    }

    public static String createProjectAwareUrl(String projectName, String resourceName) {
        StringBuilder sb = new StringBuilder();
        sb.append(PROJECT_AWARE_PROTOCOL_HEADER);
        sb.append(projectName);
        sb.append('/');
        sb.append(resourceName);
        return sb.toString();
    }
}

