/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.mylyn.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.mylyn.core.BeansContextStructureBridge;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public class BeansActiveFoldingListener
extends AbstractContextListener {
    private static BeansContextStructureBridge BRIDGE = (BeansContextStructureBridge)ContextCore.getStructureBridge((String)"spring/beans");
    private final IEditorPart editor;
    private boolean enabled = false;
    private Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                    BeansActiveFoldingListener.this.enabled = true;
                } else {
                    BeansActiveFoldingListener.this.enabled = false;
                }
                BeansActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public BeansActiveFoldingListener(IEditorPart editor) {
        this.editor = editor;
        ContextCorePlugin.getContextManager().addListener((AbstractContextListener)this);
        JavaUiBridgePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
        this.enabled = JavaUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        this.updateFolding();
    }

    private void collapseDocument(ProjectionAnnotationModel annotationModel) {
        if (annotationModel != null) {
            Iterator annotations = annotationModel.getAnnotationIterator();
            while (annotations.hasNext()) {
                Annotation annotation = (Annotation)annotations.next();
                annotationModel.collapse(annotation);
            }
        }
    }

    public void contextActivated(IInteractionContext context) {
        this.updateFolding();
    }

    public void contextCleared(IInteractionContext context) {
        this.updateFolding();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.updateFolding();
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this);
        JavaUiBridgePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public void elementDeleted(IInteractionElement node) {
    }

    private void expandDocument(ProjectionAnnotationModel annotationModel) {
        Iterator annotations = annotationModel.getAnnotationIterator();
        while (annotations.hasNext()) {
            Annotation annotation = (Annotation)annotations.next();
            annotationModel.expand(annotation);
        }
    }

    private void expandIfElementIsOfInterest(ProjectionAnnotationModel annotationModel, IStructuredDocument document, ISourceModelElement modelElement) {
        IInteractionElement mylynElement;
        if (annotationModel != null && (mylynElement = ContextCorePlugin.getContextManager().getElement(BRIDGE.getHandleIdentifier(modelElement))) != null && mylynElement.getInterest().isInteresting()) {
            try {
                int startOffset = document.getLineOffset(modelElement.getElementStartLine());
                int endOffset = document.getLineOffset(modelElement.getElementEndLine());
                int length = endOffset - startOffset;
                annotationModel.expandAll(startOffset, length);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void interestChanged(List<IInteractionElement> elements) {
        final ITextEditor viewer = (ITextEditor)this.editor.getAdapter(ITextEditor.class);
        IWorkbench workbench = PlatformUI.getWorkbench();
        for (final IInteractionElement element : elements) {
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer instanceof StructuredTextEditor && ((StructuredTextEditor)viewer).getTextViewer() != null) {
                        Object modelElement;
                        IStructuredDocument document = ((StructuredTextEditor)viewer).getModel().getStructuredDocument();
                        ProjectionAnnotationModel annotationModel = ((StructuredTextEditor)viewer).getTextViewer().getProjectionAnnotationModel();
                        if (element != null && (modelElement = BRIDGE.getObjectForHandle(element.getHandleIdentifier())) != null && modelElement instanceof ISourceModelElement) {
                            BeansActiveFoldingListener.this.expandIfElementIsOfInterest(annotationModel, document, (ISourceModelElement)modelElement);
                        }
                    }
                }
            });
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void updateFolding() {
        final ITextEditor viewer = (ITextEditor)this.editor.getAdapter(ITextEditor.class);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectionAnnotationModel annotationModel;
                    if (viewer instanceof StructuredTextEditor && ((StructuredTextEditor)viewer).getTextViewer() != null && (annotationModel = ((StructuredTextEditor)viewer).getTextViewer().getProjectionAnnotationModel()) != null) {
                        BeansActiveFoldingListener.this.expandDocument(annotationModel);
                    }
                }
            });
        } else {
            if (this.editor.getEditorInput() == null || !(this.editor.getEditorInput() instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput editorInput = (IFileEditorInput)this.editor.getEditorInput();
            IFile file = editorInput.getFile();
            if (file != null && BeansContextStructureBridge.isBeansConfig(file)) {
                final IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig(file);
                workbench.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (viewer instanceof StructuredTextEditor && ((StructuredTextEditor)viewer).getTextViewer() != null) {
                            ProjectionAnnotationModel annotationModel = ((StructuredTextEditor)viewer).getTextViewer().getProjectionAnnotationModel();
                            BeansActiveFoldingListener.this.collapseDocument(annotationModel);
                            IStructuredDocument document = ((StructuredTextEditor)viewer).getModel().getStructuredDocument();
                            for (IBean bean : BeansModelUtils.getBeans((IModelElement)beansConfig, (IProgressMonitor)new NullProgressMonitor())) {
                                BeansActiveFoldingListener.this.expandIfElementIsOfInterest(annotationModel, document, (ISourceModelElement)bean);
                            }
                        }
                    }
                });
            }
        }
    }
}

