/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.ide.eclipse.data.jdt.core.KeywordProvider;
import org.springframework.ide.eclipse.data.jdt.core.TypePredicates;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class KeywordProviderSupport
implements KeywordProvider {
    protected static final MultiValueMap<String, Part.Type> KEYWORDS = new LinkedMultiValueMap();
    private final TypePredicates predicates;
    private final MultiValueMap<String, Part.Type> keywordSuperset;

    static {
        KEYWORDS.put((Object)Number.class.getName(), Arrays.asList(Part.Type.GREATER_THAN, Part.Type.GREATER_THAN_EQUAL, Part.Type.BEFORE, Part.Type.LESS_THAN, Part.Type.LESS_THAN_EQUAL));
        KEYWORDS.put((Object)String.class.getName(), Arrays.asList(Part.Type.LIKE, Part.Type.NOT_LIKE, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH, Part.Type.CONTAINING));
        KEYWORDS.put((Object)Date.class.getName(), Arrays.asList(Part.Type.BEFORE, Part.Type.BETWEEN, Part.Type.AFTER));
        KEYWORDS.put((Object)Object.class.getName(), Arrays.asList(Part.Type.IS_NOT_NULL, Part.Type.IS_NULL, Part.Type.IN, Part.Type.NOT_IN, Part.Type.EXISTS, Part.Type.SIMPLE_PROPERTY));
        KEYWORDS.put((Object)Boolean.class.getName(), Arrays.asList(Part.Type.TRUE, Part.Type.FALSE));
        KEYWORDS.put((Object)Collection.class.getName(), Arrays.asList(Part.Type.CONTAINING));
    }

    public KeywordProviderSupport(TypePredicates predicates) {
        this(predicates, (MultiValueMap<String, Part.Type>)new LinkedMultiValueMap());
    }

    public KeywordProviderSupport(TypePredicates predicates, MultiValueMap<String, Part.Type> additionalKeywords) {
        Assert.notNull((Object)predicates);
        Assert.notNull(additionalKeywords);
        this.predicates = predicates;
        this.keywordSuperset = new LinkedMultiValueMap();
        this.keywordSuperset.putAll(KEYWORDS);
        this.keywordSuperset.putAll(additionalKeywords);
    }

    @Override
    public Set<String> getKeywordsForPropertyOf(IType type, String seed) {
        HashSet<String> result = new HashSet<String>();
        Set<String> candidates = this.getKeywordsForPropertyOf(type);
        if (!StringUtils.hasText((String)seed)) {
            return candidates;
        }
        for (String candidate : candidates) {
            if (!candidate.startsWith(seed)) continue;
            result.add(candidate);
        }
        return result;
    }

    private Set<String> getKeywordsForPropertyOf(IType type) {
        if (type == null) {
            return Collections.emptySet();
        }
        Set<Part.Type> source = this.getPartTypesForPropertyOf(type);
        if (source.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Part.Type partType : source) {
            result.addAll(partType.getKeywords());
        }
        return result;
    }

    Set<Part.Type> getPartTypesForPropertyOf(IType type) {
        if (type == null) {
            return Collections.emptySet();
        }
        HashSet<Part.Type> keywords = new HashSet<Part.Type>();
        for (String typeKey : this.keywordSuperset.keySet()) {
            if (!typeKey.equals(type.getFullyQualifiedName()) && !this.predicates.typeImplements(type, typeKey)) continue;
            keywords.addAll((Collection)this.keywordSuperset.get((Object)typeKey));
        }
        keywords.removeAll(this.getUnsupportedKeywords());
        return keywords;
    }

    protected List<Part.Type> getUnsupportedKeywords() {
        return Collections.emptyList();
    }
}

