/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.springframework.util.Assert;

public class InvalidDerivedQueryProblem
extends CategorizedProblem {
    private final IMethod method;
    private final String message;

    public InvalidDerivedQueryProblem(IMethod method, String message) {
        Assert.notNull((Object)method);
        Assert.hasText((String)message);
        this.method = method;
        this.message = message;
    }

    public String[] getArguments() {
        return new String[0];
    }

    public int getID() {
        return 0;
    }

    public String getMessage() {
        return "Invalid derived query! " + this.message;
    }

    public char[] getOriginatingFileName() {
        return this.method.getResource().getFullPath().toString().toCharArray();
    }

    public int getSourceEnd() {
        try {
            return this.method.getSourceRange().getOffset() + this.method.getSourceRange().getLength();
        }
        catch (JavaModelException javaModelException) {
            return 0;
        }
    }

    public int getSourceLineNumber() {
        try {
            return this.method.getNameRange().getOffset();
        }
        catch (JavaModelException javaModelException) {
            return 0;
        }
    }

    public int getSourceStart() {
        return this.getSourceLineNumber();
    }

    public boolean isError() {
        return true;
    }

    public boolean isWarning() {
        return false;
    }

    public void setSourceEnd(int arg0) {
    }

    public void setSourceLineNumber(int arg0) {
    }

    public void setSourceStart(int arg0) {
    }

    public int getCategoryID() {
        return 20;
    }

    public String getMarkerType() {
        return null;
    }
}

