/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.launch;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchList;

public class LiveProcessTracker
extends LaunchList {
    private static LiveProcessTracker instance;
    private final LinkedList<IProcess> processes = new LinkedList();

    public static synchronized LiveProcessTracker getInstance() {
        if (instance == null) {
            instance = new LiveProcessTracker();
        }
        return instance;
    }

    private LiveProcessTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTerminated(IProcess process) {
        boolean changed;
        LiveProcessTracker liveProcessTracker = this;
        synchronized (liveProcessTracker) {
            changed = this.processes.remove(process);
        }
        if (changed) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processCreated(IProcess process) {
        boolean changed = false;
        LiveProcessTracker liveProcessTracker = this;
        synchronized (liveProcessTracker) {
            if (!this.processes.contains(process)) {
                this.processes.add(process);
                changed = true;
            }
        }
        if (changed) {
            this.fireChangeEvent();
        }
    }

    @Override
    public synchronized LaunchList.Item getLast() {
        if (!this.processes.isEmpty()) {
            ILaunch l = this.processes.getLast().getLaunch();
            ILaunchConfiguration c = l.getLaunchConfiguration();
            if (l != null && c != null) {
                return new LaunchList.Item(c, l.getLaunchMode());
            }
        }
        return null;
    }

    @Override
    public synchronized Collection<LaunchList.Item> getLaunches() {
        LinkedHashMap<String, LaunchList.Item> launches = new LinkedHashMap<String, LaunchList.Item>();
        for (IProcess p : this.processes) {
            ILaunchConfiguration c;
            ILaunch l = p.getLaunch();
            if (l == null || (c = l.getLaunchConfiguration()) == null) continue;
            launches.put(c.getName(), new LaunchList.Item(c, l.getLaunchMode()));
        }
        return launches.values();
    }

    public static interface Listener {
        public void changed();
    }
}

