/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.internal.navigator.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

public class ShowBeansGraphAction
extends AbstractNavigatorAction {
    private IResourceModelElement element;
    private IModelElement context;

    public ShowBeansGraphAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("Open Dependency &Graph");
        this.setToolTipText("Open the Bean Dependency Graph");
        this.setImageDescriptor(BeansGraphImages.DESC_OBJS_BEANS_GPRAH);
    }

    public boolean isEnabled(IStructuredSelection selection) {
        ITreeSelection tSelection;
        if (selection instanceof ITreeSelection && (tSelection = (ITreeSelection)selection).size() == 1) {
            Object tElement = tSelection.getFirstElement();
            IResourceModelElement rElement = null;
            if (tElement instanceof IResourceModelElement) {
                if (tElement instanceof IBeansConfig || tElement instanceof IBeansConfigSet || tElement instanceof IBeansComponent || tElement instanceof IBean) {
                    rElement = (IResourceModelElement)tElement;
                }
            } else if (tElement instanceof IFile) {
                rElement = BeansCorePlugin.getModel().getConfig((IFile)tElement);
            } else if (tElement instanceof ZipEntryStorage) {
                rElement = BeansModelUtils.getConfig((ZipEntryStorage)((ZipEntryStorage)tElement));
            }
            if (rElement != null) {
                this.element = rElement;
                this.context = BeansUIUtils.getContext((ITreeSelection)tSelection);
                return true;
            }
        }
        return false;
    }

    public void run() {
        GraphEditorInput input = this.element instanceof IBeansConfig || this.element instanceof IBeansConfigSet ? new GraphEditorInput(this.element.getElementID()) : new GraphEditorInput(this.element.getElementID(), this.context.getElementID());
        SpringUIUtils.openInEditor((IEditorInput)input, (String)"org.springframework.ide.eclipse.beans.ui.graph.editor");
    }
}

