/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Util {
    public static final String CURRENT_LOCAL_FOLDER = ".";
    public static final String SERVER_SEPARATOR = "/";
    public static Method isHiddenMethod;
    public static boolean isHiddenUnsupported;
    public static Method isFilteredMethod;
    public static boolean isFilteredUnsupported;

    public static String getLastSegment(String path) {
        int index = path.lastIndexOf(SERVER_SEPARATOR);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String appendPath(String prefix, String suffix) {
        if (prefix.length() == 0 || prefix.equals(CURRENT_LOCAL_FOLDER)) {
            return suffix;
        }
        if (prefix.endsWith(SERVER_SEPARATOR)) {
            if (suffix.startsWith(SERVER_SEPARATOR)) {
                return String.valueOf(prefix) + suffix.substring(1);
            }
            return String.valueOf(prefix) + suffix;
        }
        if (suffix.startsWith(SERVER_SEPARATOR)) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + SERVER_SEPARATOR + suffix;
    }

    public static void logError(String message, Throwable throwable) {
        SVNProviderPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", 4, message, throwable));
    }

    public static String getParentUrl(ISVNLocalResource svnResource) throws SVNException {
        ISVNLocalFolder parent = svnResource.getParent();
        while (parent != null) {
            String url = parent.getStatus().getUrlString();
            if (url != null) {
                return url;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(SERVER_SEPARATOR);
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unescape(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception exception) {
            return s;
        }
    }

    public static void saveLocalHistory(IResource resource) throws CoreException {
        if (resource instanceof IFile && resource.exists()) {
            if (!resource.isSynchronized(0)) {
                resource.refreshLocal(0, null);
            }
            ((IFile)resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), 2, null);
        }
    }

    public static boolean isSpecialEclipseFile(IResource resource) {
        return resource.getName().equals(".project") || resource.getName().equals(".classpath");
    }

    public static boolean isHidden(IResource resource) {
        return Util.isHidden(resource, true);
    }

    public static boolean isHidden(IResource resource, boolean checkParents) {
        if (resource instanceof Resource && !isFilteredUnsupported) {
            if (isFilteredMethod == null) {
                try {
                    Util.isFilteredSupported();
                }
                catch (Exception exception) {
                    isFilteredUnsupported = true;
                }
            }
            if (!isFilteredUnsupported) {
                Resource checkResource = (Resource)resource;
                try {
                    Object isFiltered = isFilteredMethod.invoke((Object)checkResource, new Object[0]);
                    if (isFiltered instanceof Boolean && ((Boolean)isFiltered).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (isHiddenUnsupported) {
            return false;
        }
        if (isHiddenMethod == null) {
            try {
                Util.isHiddenSupported();
            }
            catch (Exception exception) {
                isHiddenUnsupported = true;
                return false;
            }
        }
        if (checkParents) {
            IResource parent = resource;
            while (parent != null) {
                try {
                    Object isHidden = isHiddenMethod.invoke((Object)parent, new Object[0]);
                    if (isHidden instanceof Boolean && ((Boolean)isHidden).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    public static boolean isHiddenSupported() throws NoSuchMethodException {
        if (isHiddenUnsupported) {
            return false;
        }
        isHiddenMethod = IResource.class.getDeclaredMethod("isHidden", new Class[0]);
        return isHiddenMethod != null;
    }

    public static boolean isFilteredSupported() throws NoSuchMethodException {
        if (isFilteredUnsupported) {
            return false;
        }
        isFilteredMethod = Resource.class.getDeclaredMethod("isFiltered", new Class[0]);
        return isFilteredMethod != null;
    }

    public static SVNUrl getUrlForRevision(ISVNRemoteResource resource, SVNRevision.Number revision, IProgressMonitor pm) throws SVNException {
        SVNUrl url = resource.getUrl();
        SVNRevision.Number revisionStart = new SVNRevision.Number(revision.getNumber());
        GetLogsCommand getLogsCommand = new GetLogsCommand(resource, SVNRevision.HEAD, (SVNRevision)revisionStart, SVNRevision.HEAD, false, 0L, null, true);
        getLogsCommand.run(pm);
        ILogEntry[] logEntries = getLogsCommand.getLogEntries();
        String path = resource.getRepositoryRelativePath().replaceAll("%20", " ");
        int i = logEntries.length - 1;
        while (i > -1) {
            ILogEntry logEntry = logEntries[i];
            if (!logEntry.getRevision().equals((Object)revision)) {
                LogEntryChangePath[] changePaths;
                LogEntryChangePath[] logEntryChangePathArray = changePaths = logEntry.getLogEntryChangePaths();
                int n = 0;
                int n2 = logEntryChangePathArray.length;
                while (n < n2) {
                    LogEntryChangePath changePath = logEntryChangePathArray[n];
                    if (changePath.getPath().equals(path) && changePath.getCopySrcPath() != null) {
                        try {
                            path = changePath.getCopySrcPath();
                            url = new SVNUrl(String.valueOf(resource.getRepository().getRepositoryRoot().toString()) + changePath.getCopySrcPath());
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    ++n;
                }
            }
            --i;
        }
        return url;
    }
}

