/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.subclipse.core.status.StatusUpdateStrategy;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class NonRecursiveStatusUpdateStrategy
extends StatusUpdateStrategy {
    public NonRecursiveStatusUpdateStrategy(IStatusCache statusCache) {
        super(statusCache);
    }

    protected ISVNStatus[] statusesToUpdate(IResource resource) throws SVNException {
        IResource resourceToUpdate = resource;
        if (resource.getType() == 1) {
            resourceToUpdate = resource.getParent();
        }
        if (Policy.DEBUG_STATUS) {
            System.out.println("[svn] getting status for : " + resourceToUpdate.getFullPath());
        }
        ISVNStatus[] statuses = null;
        ISVNClientAdapter svnClientAdapterStatus = null;
        try {
            try {
                svnClientAdapterStatus = SVNProviderPlugin.getPlugin().getSVNClient();
                SVNProviderPlugin.disableConsoleLogging();
                statuses = svnClientAdapterStatus.getStatus(resourceToUpdate.getLocation().toFile(), false, true);
            }
            catch (SVNClientException e1) {
                throw SVNException.wrapException((Exception)((Object)e1));
            }
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClientAdapterStatus);
        }
        return this.collectUnversionedFolders(statuses, false);
    }
}

