/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLock;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteFile
extends RemoteResource
implements ISVNRemoteFile {
    private ISVNLock lock;
    private boolean cached = false;

    public RemoteFile(IResource local, byte[] bytes) {
        super(local, bytes);
    }

    public RemoteFile(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        super(parent, repository, url, revision, lastChangedRevision, date, author);
    }

    public RemoteFile(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        super(repository, url, revision);
    }

    public RemoteFile(RemoteResourceStatus remoteStatusInfo) {
        this(null, remoteStatusInfo.getRepository(), remoteStatusInfo.getUrl(), (SVNRevision)remoteStatusInfo.getRepositoryRevision(), remoteStatusInfo.getLastChangedRevision(), remoteStatusInfo.getLastChangedDate(), remoteStatusInfo.getLastCommitAuthor());
    }

    public ISVNLock getLock() {
        return this.lock;
    }

    public void setLock(ISVNLock lock) {
        this.lock = lock;
    }

    public void fetchContents(IProgressMonitor aMonitor) throws TeamException {
        IProgressMonitor monitor = Policy.monitorFor(aMonitor);
        monitor.beginTask(Policy.bind("RemoteFile.getContents"), 100);
        ISVNClientAdapter svnClient = null;
        try {
            svnClient = this.repository.getSVNClient();
            InputStream inputStream = null;
            try {
                if (this.pegRevision != null) {
                    try {
                        inputStream = svnClient.getContent(this.url, this.revision, this.pegRevision);
                    }
                    catch (SVNClientException sVNClientException) {}
                }
                if (inputStream == null) {
                    inputStream = svnClient.getContent(this.url, this.getRevision(), this.getRevision());
                }
                super.setContents(inputStream, monitor);
                this.cached = true;
            }
            catch (SVNClientException e) {
                throw new TeamException("Failed in RemoteFile.getContents()", (Throwable)e);
            }
        }
        finally {
            this.repository.returnSVNClient(svnClient);
            monitor.done();
        }
    }

    public ISVNRemoteResource[] members(IProgressMonitor progress) {
        return new ISVNRemoteResource[0];
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isFolder() {
        return false;
    }

    protected boolean isHandleCached() {
        if (this.revision.equals((Object)SVNRevision.HEAD) && !this.cached) {
            return false;
        }
        return super.isHandleCached();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remote = (RemoteFile)target;
        return super.equals(target) && remote.getLastChangedRevision() == this.getLastChangedRevision();
    }

    public ISVNAnnotations getAnnotations(SVNRevision fromRevision, SVNRevision toRevision, boolean includeMergedRevisions, boolean ignoreMimeType) throws TeamException {
        ISVNClientAdapter svnClient = this.repository.getSVNClient();
        try {
            ISVNAnnotations iSVNAnnotations = svnClient.annotate(this.url, fromRevision, toRevision, this.pegRevision, ignoreMimeType, includeMergedRevisions);
            return iSVNAnnotations;
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in remoteFile.getAnnotations()", (Throwable)e);
        }
        finally {
            this.repository.returnSVNClient(svnClient);
        }
    }
}

