/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.util;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansTypeHierachyState;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.TypeStructureState;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;

public class AopReferenceModelUtils {
    private static final String JAVA_FILE_EXTENSION = ".java";

    public static String getJavaElementLinkNameForMarker(IMember je) {
        if (je == null) {
            return "";
        }
        if (je instanceof IMethod) {
            return String.valueOf(((IMethod)je).getDeclaringType().getFullyQualifiedName()) + '.' + AopReferenceModelUtils.readableName((IMethod)je);
        }
        return AopReferenceModelUtils.getJavaElementLinkName((IJavaElement)je);
    }

    public static String getJavaElementLinkName(IJavaElement je) {
        if (je == null) {
            return "";
        }
        if (je instanceof IMethod) {
            return AopReferenceModelUtils.readableName((IMethod)je);
        }
        if (je instanceof IType) {
            return je.getElementName();
        }
        if (je instanceof IField) {
            return String.valueOf(je.getElementName()) + " - " + ((IType)je.getParent()).getFullyQualifiedName();
        }
        if (je.getParent() != null) {
            return String.valueOf(je.getParent().getElementName()) + '.' + je.getElementName();
        }
        return je.getElementName();
    }

    public static String getPackageLinkName(IJavaElement je) {
        if (je instanceof IMethod) {
            return ((IMethod)je).getDeclaringType().getPackageFragment().getElementName();
        }
        if (je instanceof IType) {
            return ((IType)je).getPackageFragment().getElementName();
        }
        return je.getElementName();
    }

    public static String readableName(IMethod method) {
        int length;
        StringBuffer buffer = new StringBuffer(method.getElementName());
        buffer.append('(');
        String[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString((String)parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getElementDescription(IAopReference reference) {
        StringBuffer buf = new StringBuffer(": <");
        buf.append(reference.getDefinition().getAspectName());
        buf.append("> [");
        buf.append(reference.getDefinition().getResource().getProjectRelativePath().toString());
        buf.append("]");
        return buf.toString();
    }

    public static Set<IFile> getAffectedFilesFromBeansProject(IProject file) {
        Set configs;
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        IBeansProject bp = BeansCorePlugin.getModel().getProject(file.getProject());
        Set set = configs = bp != null ? bp.getConfigs() : null;
        if (configs != null && configs.size() > 0) {
            for (IBeansConfig config : configs) {
                affectedFiles.add((IFile)config.getElementResource());
            }
        }
        return affectedFiles;
    }

    public static Set<IResource> getAffectedFiles(int kind, int deltaKind, IResource resource, IProjectContributorState context) {
        IBeansProject beansProject;
        HashSet<IBeansConfig> configs = new HashSet<IBeansConfig>();
        if (kind != 6 && resource instanceof IFile && resource.getName().endsWith(JAVA_FILE_EXTENSION)) {
            TypeStructureState structureState = (TypeStructureState)context.get(TypeStructureState.class);
            BeansTypeHierachyState hierachyState = (BeansTypeHierachyState)context.get(BeansTypeHierachyState.class);
            if (structureState == null || structureState.hasStructuralChanges(resource, 24)) {
                if (deltaKind == 2) {
                    IBeansProject beansProject2 = BeansCorePlugin.getModel().getProject(resource.getProject());
                    if (beansProject2 != null) {
                        for (IBeansConfig beansConfig : beansProject2.getConfigs()) {
                            configs.add(beansConfig);
                        }
                    }
                } else {
                    for (IBeansConfig config : hierachyState.getConfigsByContainingTypes(resource)) {
                        configs.add(config);
                    }
                }
            }
        } else if (BeansCoreUtils.isBeansConfig((IResource)resource, (boolean)true)) {
            IBeansConfig beansConfig = (IBeansConfig)BeansModelUtils.getResourceModelElement((Object)resource);
            if (beansConfig instanceof IImportedBeansConfig) {
                beansConfig = (IBeansConfig)BeansModelUtils.getParentOfClass((IModelElement)beansConfig, IBeansConfig.class);
            }
            configs.add(beansConfig);
            for (IBeansProject bp : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfig bc : bp.getConfigs()) {
                    for (IBeansImport bi : bc.getImports()) {
                        for (IImportedBeansConfig ibc : bi.getImportedBeansConfigs()) {
                            if (!ibc.getElementResource().equals((Object)resource)) continue;
                            configs.add(bc);
                        }
                    }
                }
            }
        } else if (JdtUtils.isClassPathFile((IResource)resource) && (beansProject = BeansCorePlugin.getModel().getProject(resource.getProject())) != null) {
            for (IBeansConfig beansConfig : beansProject.getConfigs()) {
                configs.add(beansConfig);
            }
        }
        LinkedHashSet<IResource> files = new LinkedHashSet<IResource>();
        for (IBeansConfig config : configs) {
            files.add(config.getElementResource());
        }
        return files;
    }

    public static Set<IResource> getAffectedFilesFromBeansConfig(Set<IResource> files) {
        LinkedHashSet<IResource> newResources = new LinkedHashSet<IResource>();
        for (IResource resource : files) {
            IBeansProject project = BeansCorePlugin.getModel().getProject(resource.getProject());
            IBeansConfig beansConfig = project.getConfig((IFile)resource);
            if (project == null) continue;
            Set configSets = project.getConfigSets();
            for (IBeansConfigSet configSet : configSets) {
                if (!configSet.getConfigs().contains(beansConfig)) continue;
                Set bcs = configSet.getConfigs();
                for (IBeansConfig bc : bcs) {
                    newResources.add(bc.getElementResource());
                }
            }
        }
        newResources.addAll(files);
        return newResources;
    }

    public static IBean getBeanFromElementId(String elementId) {
        IBeansModel model = BeansCorePlugin.getModel();
        return (IBean)model.getElement(elementId);
    }
}

