/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.ui.BasicTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicTableManager;
import net.sourceforge.pmd.eclipse.ui.views.AbstractStructureInspectorPage;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTPainterHelper;
import net.sourceforge.pmd.eclipse.ui.views.ast.NodeColumnUI;
import net.sourceforge.pmd.eclipse.ui.views.ast.XPathEvaluator;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ParseException;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;

public class ASTViewPage
extends AbstractStructureInspectorPage {
    private SashForm sashForm;
    protected TreeViewer astViewer;
    private StyledText xpathField;
    private TableViewer resultsViewer;
    private Button goButton;
    private Node classNode;
    private ASTPainterHelper helper;
    private ASTContentProvider contentProvider;
    private static Set<Class<?>> HiddenNodeTypes = new HashSet();

    static {
        HiddenNodeTypes.add(ASTImportDeclaration.class);
    }

    public TreeViewer astViewer() {
        return this.astViewer;
    }

    public void showImports(boolean flag) {
        this.contentProvider.includeImports(flag);
        this.astViewer.refresh();
    }

    public void showComments(boolean flag) {
        this.contentProvider.includeComments(flag);
        this.astViewer.refresh();
    }

    public ASTViewPage(IWorkbenchPart part, FileRecord record) {
        super(part, record);
    }

    public void createControl(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        Composite astPanel = new Composite((Composite)this.sashForm, 0);
        GridLayout mainLayout = new GridLayout(3, false);
        astPanel.setLayout((Layout)mainLayout);
        Composite titleArea = new Composite(astPanel, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        titleArea.setLayoutData((Object)gridData);
        titleArea.setLayout((Layout)new GridLayout(4, false));
        Label showLabel = new Label(titleArea, 0);
        showLabel.setText("Show: ");
        final Button classBtn = new Button(titleArea, 16);
        classBtn.setText("Class");
        classBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (classBtn.getSelection()) {
                    ASTViewPage.this.showClass();
                }
            }
        });
        final Button methodBtn = new Button(titleArea, 16);
        methodBtn.setText("Method");
        methodBtn.setSelection(true);
        methodBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ASTViewPage.this.enableMethodSelector(methodBtn.getSelection());
                ASTViewPage.this.methodPicked();
            }
        });
        this.buildMethodSelector(titleArea);
        this.astViewer = new TreeViewer(astPanel, 2050);
        this.contentProvider = new ASTContentProvider(true, true);
        this.astViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.astViewer.setLabelProvider((IBaseLabelProvider)new ASTLabelProvider());
        this.setupListeners(this.astViewer.getTree());
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.astViewer.getTree().setLayoutData((Object)data);
        Composite xpathTestPanel = new Composite((Composite)this.sashForm, 0);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        xpathTestPanel.setLayoutData((Object)data);
        GridLayout playLayout = new GridLayout(2, false);
        xpathTestPanel.setLayout((Layout)playLayout);
        this.xpathField = new StyledText(xpathTestPanel, 2816);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.xpathField.setLayoutData((Object)gridData);
        SyntaxManager.adapt(this.xpathField, "xpath", null);
        this.addXPathValidator();
        this.goButton = new Button(xpathTestPanel, 8);
        this.goButton.setText("GO");
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = 1;
        this.goButton.setLayoutData((Object)gridData);
        this.goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTViewPage.this.evaluateXPath();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        BasicTableManager tableMgr = new BasicTableManager("ast", null, NodeColumnUI.VisibleColumns);
        this.resultsViewer = tableMgr.buildTableViewer(xpathTestPanel);
        tableMgr.setupColumns(NodeColumnUI.VisibleColumns);
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Node[])inputElement;
            }
        };
        BasicTableLabelProvider labelProvider = new BasicTableLabelProvider(NodeColumnUI.VisibleColumns);
        Table table = this.resultsViewer.getTable();
        table.setLayoutData((Object)gridData);
        this.resultsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.resultsViewer.setContentProvider((IContentProvider)contentProvider);
        this.registerListeners();
        this.showFirstMethod();
    }

    private void addXPathValidator() {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ASTViewPage.this.validateXPath(ASTViewPage.this.xpathField.getText());
            }
        };
        this.xpathField.addModifyListener(ml);
    }

    private void validateXPath(String xpathString) {
        try {
            new BaseXPath(xpathString, null);
        }
        catch (XPathSyntaxException ex) {
            System.out.println(String.valueOf(ex.getPosition()) + "  " + ex.getMessage());
            this.goButton.setEnabled(false);
            return;
        }
        catch (JaxenException jaxenException) {
            this.goButton.setEnabled(false);
            return;
        }
        this.goButton.setEnabled(true);
    }

    private void evaluateXPath() {
        if (!this.setupTest()) {
            return;
        }
        List<Node> results = null;
        try {
            results = XPathEvaluator.instance.evaluate(this.getDocument().get(), this.xpathField.getText(), "1.0");
        }
        catch (ParseException pe) {
            this.showError(pe.fillInStackTrace().getMessage());
            return;
        }
        this.show(results);
    }

    private boolean setupTest() {
        this.resultsViewer.getTable().clearAll();
        return !StringUtil.isEmpty((String)this.xpathField.getText());
    }

    private void showError(String message) {
    }

    private void show(List<Node> results) {
        if (results.isEmpty()) {
            return;
        }
        this.resultsViewer.setInput((Object)results.toArray(new Node[results.size()]));
    }

    private void setupListeners(Tree tree) {
        this.helper = new ASTPainterHelper(tree.getDisplay());
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TextLayout layout = ASTViewPage.this.helper.layoutFor((TreeItem)event.item);
                layout.draw(event.gc, event.x + 5, event.y);
            }
        });
        tree.addListener(41, new Listener(){

            public void handleEvent(Event e) {
                Rectangle textLayoutBounds = ASTViewPage.this.helper.layoutFor((TreeItem)e.item).getBounds();
                e.width = textLayoutBounds.width + 2;
                e.height = textLayoutBounds.height + 2;
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ASTViewPage.this.highlightItem(se.item.getData());
            }
        });
    }

    private void highlightItem(Object item) {
        AbstractNode node = (AbstractNode)item;
        this.highlight(node.getBeginLine() - 1, node.getBeginColumn() - 1, node.getEndLine() - 1, node.getEndColumn());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.helper.dispose();
    }

    public Control getControl() {
        return this.sashForm;
    }

    protected void showClass() {
        if (this.classNode == null) {
            String source = this.getDocument().get();
            this.classNode = XPathEvaluator.instance.getCompilationUnit(source);
        }
        this.astViewer.setInput((Object)this.classNode);
        this.astViewer.expandAll();
    }

    @Override
    protected void showMethod(ASTMethodDeclaration pmdMethod) {
        if (pmdMethod == null) {
            return;
        }
        this.astViewer.setInput((Object)pmdMethod);
        this.astViewer.expandAll();
    }

    @Override
    public void refresh(IResource newResource) {
        super.refresh(newResource);
        this.classNode = null;
        this.refreshMethodSelector();
    }
}

