/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeText;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.TypeProperty;
import net.sourceforge.pmd.util.ClassUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TypeEditorFactory
extends AbstractEditorFactory {
    public static final TypeEditorFactory instance = new TypeEditorFactory();

    private TypeEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new TypeProperty(name, description, String.class, new String[]{"java.lang"}, 0.0f);
    }

    public static Class<?> typeFor(String typeName) {
        Class newType = ClassUtil.getTypeFor((String)typeName);
        if (newType != null) {
            return newType;
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return ((TypeText)valueControl).getType(false);
    }

    protected void fillWidget(TypeText textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        Class type = (Class)this.valueFor(source, desc);
        textWidget.setType(type);
    }

    private static TypeProperty typePropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (TypeProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (TypeProperty)desc;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final TypeText typeText = new TypeText(parent, 2052, true, "Enter a type name");
        typeText.setLayoutData(new GridData(768));
        this.fillWidget(typeText, desc, source);
        final TypeProperty tp = TypeEditorFactory.typePropertyFrom(desc);
        Listener wereDoneListener = new Listener(){

            public void handleEvent(Event event) {
                Class<?> newValue = typeText.getType(true);
                if (newValue == null) {
                    return;
                }
                Class existingValue = (Class)TypeEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)tp);
                if (existingValue == newValue) {
                    return;
                }
                source.setProperty((PropertyDescriptor)tp, newValue);
                listener.changed(source, desc, newValue);
                TypeEditorFactory.this.adjustRendering(source, desc, (Control)typeText);
            }
        };
        typeText.addListener(16, wereDoneListener);
        typeText.addListener(14, wereDoneListener);
        return typeText;
    }
}

