/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class TreeUtil {
    private TreeUtil() {
    }

    public static String getSelectionAsString(TreeViewer viewer, String columnSeparator, String lineSeparator) {
        String[][] data = TreeUtil.getStringContents(viewer);
        StringBuilder sb = new StringBuilder();
        int r = 0;
        while (r < data.length) {
            sb.append(data[r][0]);
            int c = 1;
            while (c < data[r].length) {
                sb.append(columnSeparator).append(data[r][c]);
                ++c;
            }
            sb.append(lineSeparator);
            ++r;
        }
        return sb.toString();
    }

    public static String[][] getStringContents(TreeViewer viewer) {
        Object[] items = ((IStructuredSelection)viewer.getSelection()).toArray();
        ITableLabelProvider provider = (ITableLabelProvider)viewer.getLabelProvider();
        int columnCount = viewer.getTree().getColumnCount();
        String[][] output = new String[items.length][columnCount];
        int r = 0;
        while (r < items.length) {
            int c = 0;
            while (c < columnCount) {
                output[r][c] = provider.getColumnText(items[r], c);
                ++c;
            }
            ++r;
        }
        return output;
    }

    public static void copySelectionToClipboard(TreeViewer viewer) {
        Clipboard clipboard = new Clipboard(viewer.getTree().getDisplay());
        clipboard.setContents(new Object[]{TreeUtil.getSelectionAsString(viewer, "\t", System.getProperty("line.separator"))}, new Transfer[]{TextTransfer.getInstance()});
    }
}

